import { App } from 'koishi';
import { PluginDef } from '../src/def';
import { UsePlugin } from '../src/decorators';
import PluginOnebot from '@koishijs/plugin-adapter-onebot';
import { Registrar } from '../src/register';

class MyClass {
  @UsePlugin()
  loadOnebot() {
    return PluginDef(PluginOnebot, {
      bots: [{ protocol: 'wsreverse', selfId: '11111' }],
    });
  }
}

describe('Inner plugin', () => {
  let app: App;
  beforeEach(async () => {
    app = new App({ port: 11111 });
    await app.start();
    // app.plugin(PluginOnebot, { bots: [] });
  });

  it('should load inner plugin properly', () => {
    new Registrar(new MyClass()).register(app, 'loadOnebot');
    expect(app.bots.length).toBe(1);
  });
});
