// metadatas
import {
  CommandDefinitionFun,
  MappingStruct,
  OnContextFunction,
  TopLevelActionDef,
} from './interfaces';
import { CommandPut, DoRegister } from '../registry';

export const KoishiOnContextScope = 'KoishiOnContextScope';
export const KoishiDoRegister = 'KoishiDoRegister';
export const KoishiDoRegisterKeys = 'KoishiDoRegisterKeys';
export const KoishiCommandDefinition = 'KoishiCommandDefinition';
export const KoishiCommandPutDef = 'KoishiCommandPutDef';

// metadata map

export interface MetadataArrayMap {
  KoishiOnContextScope: OnContextFunction;
  KoishiCommandDefinition: CommandDefinitionFun;
  KoishiDoRegisterKeys: string;
  KoishiTopLevelAction: TopLevelActionDef;
  KoishiPutClassFieldKeys: string;
}

export interface MetadataMap {
  KoishiDoRegister: DoRegister.Config;
  KoishiPutClassField: MappingStruct<
    CommandPut.ConfigMap,
    keyof CommandPut.ConfigMap
  >;
}
