import { Logger } from 'koishi';
import { Drawer } from './drawer';

export interface YamlMeta {
  name: string;
  author: string;
  version: number;
  command: string;
  desc: string;
  includes: string[];
}

export type YamlStruct = YamlMeta & Record<string, string[]>;

export class YamlDrawer {
  private availableDecks = new Set<string>();
  private drawer = new Drawer(this.meta, this.logger, this.maxDepth);

  constructor(
    public meta: YamlStruct,
    private logger: Logger,
    private maxDepth: number,
  ) {
    for (const deck of meta.includes ?? Object.keys(meta)) {
      this.availableDecks.add(deck);
    }
  }

  draw(deck: string, username?: string) {
    deck ??= 'default';
    if (!this.availableDecks.has(deck)) {
      this.logger.warn(`Deck ${deck} not found.`);
      return;
    }
    let result = this.drawer.drawFromDeck(deck);
    if (result && username) {
      result = result.replace(/【name】/g, username);
    }
    return result;
  }

  getCommands() {
    return this.meta.includes.map((deck) =>
      deck === 'default' ? this.meta.command : `${this.meta.command} ${deck}`,
    );
  }
}
