import { Dict } from 'koishi';
import { CommandLocaleDef } from 'koishi-thirdeye';

export const fileInfo = 'File: {file} Count: {count}';
const yamlFileInfo = '{name} Author: {author} Version: {version}\n{desc}';
const listMessages = { fileInfo, yamlFileInfo };
export const commands: Dict<CommandLocaleDef> = {
  draw: {
    description: 'Draw from deck.',
    messages: {
      result: '{user} got:',
      notFound: 'The specified deck is not found.',
    },
  },
  list: {
    description: 'Check deck file list.',
    messages: listMessages,
  },
  help: {
    description: 'Check deck list.',
    messages: listMessages,
  },
  reload: {
    description: 'Reload deck files.',
    messages: {
      result: 'Loaded {deckCount} decks from {deckFileCount} deck files.',
    },
  },
  search: {
    description: 'Search for deck',
    messages: {
      result: 'Result:',
      notFound: 'Deck with keyword "{keyword}" not found.',
    },
  },
};
