// import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import * as fs from 'fs';
import path from 'path';
import _ from 'lodash';

@RegisterSchema()
export class DrawPluginConfig {
  constructor(config: DrawPluginConfigLike) {}

  @DefineSchema({
    type: String,
    description: 'Location of deck directory.',
    default: ['./decks'],
  })
  deckPaths: string[];

  @DefineSchema({
    description: 'Max depth of recurse entry parsing.',
    default: 10,
  })
  maxDepth: number;

  async loadFileList(...suffixes: string[]) {
    return _.flatten(
      await Promise.all(
        this.deckPaths.map(async (deckPath) => {
          const files = await fs.promises.readdir(deckPath);
          return files
            .filter((file) =>
              suffixes.some((suffix) => file.endsWith('.' + suffix)),
            )
            .map((file) => path.join(deckPath, file));
        }),
      ),
    );
  }
}

export type DrawPluginConfigLike = Partial<DrawPluginConfig>;
