import { CommandLocaleDef } from 'koishi-thirdeye';
import { Dict } from 'koishi';

const fileInfo = '文件名: {file} 数量: {count}';
const yamlFileInfo = '{name} 文件名: {file} 作者: {author} 版本: {version}\n{desc}';
const listMessages = { fileInfo, yamlFileInfo };
export const commands: Dict<CommandLocaleDef> = {
  draw: {
    description: '进行牌堆抽取',
    messages: {
      result: '{user} 抽到了这个:',
      notFound: '找不到指定牌堆。',
    },
  },
  list: {
    description: '查看载入了哪些牌堆文件',
    messages: listMessages,
  },
  help: {
    description: '查看有哪些牌堆名可以使用',
    messages: listMessages,
  },
  reload: {
    description: '重新载入牌堆数据',
    messages: {
      result: '从 {deckFileCount} 个牌堆文件中重新载入了 {deckCount} 个牌堆。',
    },
  },
  search: {
    description: '搜索相关牌堆',
    messages: {
      result: '搜索结果:',
      notFound: '没有找到关键词 [ {word} ]',
    },
  },
};
