// import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import * as fs from 'fs';
import path from 'path';
import _ from 'lodash';

@RegisterSchema()
export class MyPluginConfig {
  constructor(config: MyPluginConfigLike) {}

  @DefineSchema({
    type: String,
    description: 'Location of deck directory.',
    default: ['./decks'],
  })
  deckPaths: string[];

  @DefineSchema({
    description: 'Max depth of recurse entry parsing.',
    default: 10,
  })
  maxDepth: number;

  async loadFileList() {
    return _.flatten(
      await Promise.all(
        this.deckPaths.map(async (deckPath) => {
          const files = await fs.promises.readdir(deckPath);
          return files
            .filter((file) => file.endsWith('.json'))
            .map((file) => path.join(deckPath, file));
        }),
      ),
    );
  }
}

export type MyPluginConfigLike = Partial<MyPluginConfig>;
