import { Dict } from 'koishi';
import { CommandLocaleDef } from 'koishi-thirdeye';

export const fileInfo = 'File: {file} Count: {count}';
export const commands: Dict<CommandLocaleDef> = {
  draw: {
    description: 'Draw from deck.',
    messages: {
      result: '{user} got:',
      notFound: 'The specified deck is not found.',
    },
  },
  list: {
    description: 'Check deck file list.',
    messages: {
      fileInfo,
    },
  },
  help: {
    description: 'Check deck list.',
    messages: {
      fileInfo,
    },
  },
  reload: {
    description: 'Reload deck files.',
    messages: {
      result: 'Loaded {deckCount} decks from {deckFileCount} deck files.',
    },
  },
  search: {
    description: 'Search for deck',
    messages: {
      result: 'Result:',
      notFound: 'Deck with keyword "{keyword}" not found.',
    },
  },
};
