/**
 * System configuration for Angular samples
 * Adjust as necessary for your application needs.
 */
System.config({
    paths: {
        // paths serve as alias
        'npm:': 'node_modules/'
    },
    // map tells the System loader where to look for things
    map: {
        // our app is within the app folder
        app: 'app',

        // systemjs plugins
        'text': 'npm:systemjs-plugin-text/text.js',

        // angular bundles
        '@angular/core': 'npm:@angular/core/bundles/core.umd.js',
        '@angular/common': 'npm:@angular/common/bundles/common.umd.js',
        '@angular/compiler': 'npm:@angular/compiler/bundles/compiler.umd.js',
        '@angular/platform-browser': 'npm:@angular/platform-browser/bundles/platform-browser.umd.js',
        '@angular/platform-browser-dynamic': 'npm:@angular/platform-browser-dynamic/bundles/platform-browser-dynamic.umd.js',
        '@angular/http': 'npm:@angular/http/bundles/http.umd.js',
        '@angular/router': 'npm:@angular/router/bundles/router.umd.js',
        '@angular/router/upgrade': 'npm:@angular/router/bundles/router-upgrade.umd.js',
        '@angular/forms': 'npm:@angular/forms/bundles/forms.umd.js',
        '@angular/upgrade': 'npm:@angular/upgrade/bundles/upgrade.umd.js',
        '@angular/upgrade/static': 'npm:@angular/upgrade/bundles/upgrade-static.umd.js',

        // other libraries
        'rxjs': 'npm:rxjs',
        'angular-in-memory-web-api': 'npm:angular-in-memory-web-api/bundles/in-memory-web-api.umd.js',

        // node.js built-in libraries
        "buffer": "@node/buffer",
        "querystring": "@node/querystring",
        "events": "@node/events",
        "http": "@node/http",
        "cluster": "@node/cluster",
        "zlib": "@node/zlib",
        "os": "@node/os",
        "https": "@node/https",
        "punycode": "@node/punycode",
        "repl": "@node/repl",
        "readline": "@node/readline",
        "vm": "@node/vm",
        "child_process": "@node/child_process",
        "url": "@node/url",
        "dns": "@node/dns",
        "net": "@node/net",
        "glob": "@node/glob",
        "dgram": "@node/dgram",
        "fs": "@node/fs",
        "path": "@node/path",
        "string_decoder": "@node/string_decoder",
        "tls": "@node/tls",
        "crypto": "@node/crypto",
        "stream": "@node/stream",
        "util": "@node/util",
        "assert": "@node/assert",
        "tty": "@node/tty",
        "domain": "@node/domain",
        "constants": "@node/constants",
        "process": "@node/process",
        "v8": "@node/v8",
        "timers": "@node/timers",
        "console": "@node/console",

        // other node.js libraries
        "electron": "@node/electron",
        "ini": "@node/ini",
        "mkdirp": "@node/mkdirp",
        "aria2": "@node/aria2",
        "electron-sudo": "@node/electron-sudo",
        'fs-extra': '@node/fs-extra',

        'jquery': 'npm:jquery/dist/jquery.min.js',
        'tether': 'npm:tether/dist/js/tether.min.js',
        'bootstrap': 'npm:bootstrap/dist/js/bootstrap.min.js',
        'reconnecting-websocket': 'npm:reconnecting-websocket/dist/index.js',
        // 'typeahead.js': '@node/typeahead.js'

        'raven-js': 'npm:raven-js'

    },
    // packages tells the System loader how to load when no filename and/or no extension
    packages: {
        app: {
            main: './main.js',
            defaultExtension: 'js'
        },
        rxjs: {
            defaultExtension: 'js'
        },
        'raven-js': {
            main: 'dist/raven.js'
        }
    },
    meta: {
        bootstrap: {
            globals: {
                jQuery: 'jquery',
                Tether: 'tether'
            }
        }
    }
});
