package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 主表 - 比赛表
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@TableName("ta_tournament")
@ApiModel(value = "Tournament对象", description = "主表 - 比赛表")
public class TournamentPO implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("比赛 - 主键id")
  @TableId(value = "tournament_id", type = IdType.AUTO)
  private Integer tournamentId;

  @ApiModelProperty("比赛 - 比赛名称")
  private String tournamentName;

  @ApiModelProperty("比赛 - 比赛赛制【1 淘汰赛】【2 双败淘汰赛】【3 瑞士轮】")
  private String tournamentSystem;

  @ApiModelProperty("比赛 - 比赛时间（yyyy-mm-dd）")
  private String tournamentTime;

  @ApiModelProperty("比赛 - 比赛简介")
  private String tournamentIntroduction;

  @ApiModelProperty("比赛 - 桌次信息（ JSON 格式）")
  private String tournamentSeat;

  @ApiModelProperty("比赛 - 比赛轮次")
  private Integer tournamentRound;

  @ApiModelProperty("时间 - 创建时间")
  private LocalDateTime timeCreate;

  @ApiModelProperty("时间 - 修改时间")
  private LocalDateTime timeUpdate;

  @ApiModelProperty("是否有效")
  private Boolean isValid;

  public Integer getTournamentId() {
    return tournamentId;
  }

  public void setTournamentId(Integer tournamentId) {
    this.tournamentId = tournamentId;
  }

  public String getTournamentName() {
    return tournamentName;
  }

  public void setTournamentName(String tournamentName) {
    this.tournamentName = tournamentName;
  }

  public String getTournamentSystem() {
    return tournamentSystem;
  }

  public void setTournamentSystem(String tournamentSystem) {
    this.tournamentSystem = tournamentSystem;
  }

  public String getTournamentTime() {
    return tournamentTime;
  }

  public void setTournamentTime(String tournamentTime) {
    this.tournamentTime = tournamentTime;
  }

  public String getTournamentIntroduction() {
    return tournamentIntroduction;
  }

  public void setTournamentIntroduction(String tournamentIntroduction) {
    this.tournamentIntroduction = tournamentIntroduction;
  }

  public String getTournamentSeat() {
    return tournamentSeat;
  }

  public void setTournamentSeat(String tournamentSeat) {
    this.tournamentSeat = tournamentSeat;
  }

  public Integer getTournamentRound() {
    return tournamentRound;
  }

  public void setTournamentRound(Integer tournamentRound) {
    this.tournamentRound = tournamentRound;
  }

  public LocalDateTime getTimeCreate() {
    return timeCreate;
  }

  public void setTimeCreate(LocalDateTime timeCreate) {
    this.timeCreate = timeCreate;
  }

  public LocalDateTime getTimeUpdate() {
    return timeUpdate;
  }

  public void setTimeUpdate(LocalDateTime timeUpdate) {
    this.timeUpdate = timeUpdate;
  }

  public Boolean getIsValid() {
    return isValid;
  }

  public void setIsValid(Boolean isValid) {
    this.isValid = isValid;
  }

  @Override
  public String toString() {
    return "Tournament{"
        + "tournamentId="
        + tournamentId
        + ", tournamentName="
        + tournamentName
        + ", tournamentSystem="
        + tournamentSystem
        + ", tournamentTime="
        + tournamentTime
        + ", tournamentIntroduction="
        + tournamentIntroduction
        + ", tournamentSeat="
        + tournamentSeat
        + ", tournamentRound="
        + tournamentRound
        + ", timeCreate="
        + timeCreate
        + ", timeUpdate="
        + timeUpdate
        + ", isValid="
        + isValid
        + "}";
  }
}
