package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 主表 - 参赛者
 * </p>
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@TableName("ta_participant")
@ApiModel(value = "Participant对象", description = "主表 - 参赛者")
public class ParticipantPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("参赛者 - 主键")
    @TableId(value = "participant_id", type = IdType.AUTO)
    private Integer participantId;

    @ApiModelProperty("参赛者 - 参赛昵称")
    private String participantName;

    @ApiModelProperty("参赛者 - 参赛卡组")
    private String participantDeck;

    @ApiModelProperty("外键 >> 比赛 - 主键id")
    private Integer competitionId;

    @ApiModelProperty("时间 - 创建时间")
    private LocalDateTime timeCreate;

    @ApiModelProperty("是否有效 1是 0否")
    private Boolean isValid;

    public Integer getParticipantId() {
        return participantId;
    }

    public void setParticipantId(Integer participantId) {
        this.participantId = participantId;
    }
    public String getParticipantName() {
        return participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }
    public String getParticipantDeck() {
        return participantDeck;
    }

    public void setParticipantDeck(String participantDeck) {
        this.participantDeck = participantDeck;
    }
    public Integer getCompetitionId() {
        return competitionId;
    }

    public void setCompetitionId(Integer competitionId) {
        this.competitionId = competitionId;
    }
    public LocalDateTime getTimeCreate() {
        return timeCreate;
    }

    public void setTimeCreate(LocalDateTime timeCreate) {
        this.timeCreate = timeCreate;
    }
    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public String toString() {
        return "Participant{" +
            "participantId=" + participantId +
            ", participantName=" + participantName +
            ", participantDeck=" + participantDeck +
            ", competitionId=" + competitionId +
            ", timeCreate=" + timeCreate +
            ", isValid=" + isValid +
        "}";
    }
}
