package moe.mycard.tabulator.model.dto;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.Data;

/** 全局入参子类 */
@Data
public class GlobalAskBody<T> {

  /** 请求参数 */
  private T params;

  /** 页码 */
  private Integer pageNum;

  /** 一页显示的数量 */
  private Integer pageSize;

  /**
   * 构造分页
   *
   * @param <po> 构造对象
   * @return page
   */
  public <po> Page<po> buildPage() {
    return new Page<>(getPageNum(), getPageSize());
  }

  /** 返回页码 默认1 */
  public Integer getPageNum() {
    if (pageNum == null || pageNum == 0) {
      pageNum = 1;
    }
    return pageNum;
  }

  /** 返回一页显示的数量 默认20 */
  public Integer getPageSize() {
    if (pageSize == null || pageSize == 0) {
      pageSize = 20;
    }
    return pageSize;
  }
}
