package moe.mycard.tabulator.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.dto.ReturnMessage;
import moe.mycard.tabulator.model.po.TournamentPO;
import moe.mycard.tabulator.model.vo.req.SaveTournamentReq;
import moe.mycard.tabulator.model.vo.req.UpdateTournamentReq;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags = "首页页面接口")
@RequestMapping(IndexApi.api)
public interface IndexApi {

  String api = ApiEnum.api + "/index";

  @ApiOperation("新增 - 创建新的比赛")
  @PostMapping("/save_tournament")
  ReturnMessage<Void> save_tournament(@RequestBody GlobalAskBody<SaveTournamentReq> body);

  @ApiOperation("分页 - 获取比赛列表")
  @PostMapping("/page_tournament")
  ReturnMessage<Page<TournamentPO>> page_tournament(@RequestBody GlobalAskBody<?> body);

  @ApiOperation("编辑 - 单场次比赛信息")
  @PostMapping("/edit_tournament")
  ReturnMessage<Void> edit_tournament(@RequestBody GlobalAskBody<UpdateTournamentReq> body);

  @ApiOperation("删除 - 单场次比赛")
  @PostMapping("/delete_tournament")
  ReturnMessage<Void> delete_tournament(@RequestBody GlobalAskBody<Integer> body);

  @ApiOperation("详情 - 单场次比赛信息")
  @PostMapping("/details_tournament_info")
  ReturnMessage<Void> details_tournament_info(@RequestBody GlobalAskBody<Integer> body);

  @ApiOperation("导出比赛")
  @PostMapping("/export_tournament")
  ReturnMessage<Void> export_tournament(@RequestBody GlobalAskBody<Integer> body);

  @ApiOperation("比赛授权")
  @PostMapping("/authorize")
  ReturnMessage<Void> authorize(@RequestBody GlobalAskBody<?> body);
}
