package moe.mycard.tabulator.exception;

import moe.mycard.tabulator.model.dto.GlobalAskBody;

/** 异常检查器 */
public class CavCore {

  /** 单例c */
  private static volatile CavCore c;

  /**
   * 直接获取检查器
   *
   * @return ParameterCheck = new ParameterCheck()
   */
  public static CavCore getC() {
    if (c == null) {
      synchronized (CavCore.class) {
        if (c == null) {
          c = new CavCore();
        }
      }
    }
    return c;
  }

  /**
   * 错误校验
   *
   * @throws CavException 参数校验异常，携带输入的异常信息内容
   */
  public void c(boolean isMistake, String message) throws CavException {
    if (isMistake) throw CavException.cast(message);
  }

  /**
   * 错误校验
   *
   * @throws CavException 参数校验异常，携带输入的异常信息内容
   */
  public void ck(Object key, Object _key) throws CavException {
    if (key != _key) throw CavException.cast("参数错误");
  }

  /**
   * 错误校验 判空形(cn -> check null)
   *
   * @param t 实体
   * @param <object> 实体类型
   * @throws CavException 空异常，携带输入的异常信息
   * @see #cn(Object, String)
   */
  public <object> void cn(object t) throws CavException {
    cn(t, "参数为空");
  }

  /**
   * 错误校验 判空形(cn -> check null)
   *
   * @throws CavException 空异常，携带输入的异常信息
   * @see #cn(Object, String)
   */
  public void cn(GlobalAskBody<?> gbr) throws CavException {
    cn(gbr, "参数为空");
    cn(gbr.getParams(), "参数为空");
  }

  /**
   * 错误校验 判空形(cn -> check null)
   *
   * @param t 实体
   * @param message 错误信息
   * @param <object> 实体类型
   * @throws CavException 空异常，携带输入的异常信息
   */
  public <object> void cn(object t, String message) throws CavException {
    if (t == null) throw CavException.cast(message);
  }

  /**
   * 错误校验 判非空形(cn -> check null)
   *
   * @param t 实体
   * @param message 错误信息
   * @param <object> 实体类型
   * @throws CavException 空异常，携带输入的异常信息
   */
  public <object> void cnn(object t, String message) throws CavException {
    if (t != null) throw CavException.cast(message);
  }
}
