package moe.mycard.tabulator.controllers;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.val;
import moe.mycard.tabulator.api.IndexApi;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.dto.ReturnMessage;
import moe.mycard.tabulator.model.po.TournamentPO;
import moe.mycard.tabulator.model.service.ds.IndexService;
import moe.mycard.tabulator.model.vo.req.SaveTournamentReq;
import moe.mycard.tabulator.model.vo.req.UpdateTournamentReq;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
public class IndexDo implements IndexApi {

  @Resource private IndexService indexService;

  @Override
  public ReturnMessage<Void> save_tournament(GlobalAskBody<SaveTournamentReq> body) {
    indexService.saveTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<Page<TournamentPO>> page_tournament(GlobalAskBody<?> body) {
    val page = indexService.pageTournament(body);
    return ReturnMessage.data(page);
  }

  @Override
  public ReturnMessage<Void> edit_tournament(GlobalAskBody<UpdateTournamentReq> body) {
    indexService.editTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<Void> delete_tournament(GlobalAskBody<Integer> body) {
    indexService.deleteTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<Void> details_tournament_info(GlobalAskBody<Integer> body) {
    return null;
  }

  @Override
  public ReturnMessage<Void> export_tournament(GlobalAskBody<Integer> body) {
    return null;
  }

  @Override
  public ReturnMessage<Void> authorize(GlobalAskBody<?> body) {
    return null;
  }
}
