package moe.mycard.tabulator.common;

import moe.mycard.tabulator.exception.CavCore;
import moe.mycard.tabulator.exception.CavException;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
public class LoginInterceptor implements HandlerInterceptor {

  private final CavCore c = CavCore.getC();

  // 这个方法是在访问接口之前执行的，我们只需要在这里写验证登陆状态的业务逻辑，就可以在用户调用指定接口之前验证登陆状态了
  public boolean preHandle(
      HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
    String test = request.getHeader("Authentication");
    boolean auth = test != null;
    if (!auth) {
      throw CavException.cast(301, "无权访问");
    }
    return auth;
  }
}
