package moe.mycard.tabulator.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.dto.ReturnMessage;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags = "比赛相关接口")
@RequestMapping(TournamentApi.api)
public interface TournamentApi {

  String api = ApiEnum.api + "/tournament";

  @ApiOperation("编辑 - 单场次比赛信息")
  @PostMapping("/edit_tournament")
  ReturnMessage<Void> edit_tournament(@RequestBody GlobalAskBody<?> body);

  @ApiOperation("详情 - 单场次比赛信息 常规信息")
  @PostMapping("/details_tournament_info")
  ReturnMessage<Void> details_tournament_info(@RequestBody GlobalAskBody<Long> body);

  @ApiOperation("详情 - 单场次比赛信息 树形对战信息")
  @PostMapping("/details_tournament_tree")
  ReturnMessage<Void> details_tournament_tree(@RequestBody GlobalAskBody<Long> body);

  @ApiOperation("编辑 - 对局信息")
  @PostMapping("/edit_match")
  ReturnMessage<Void> edit_match(@RequestBody GlobalAskBody<?> body);

  @ApiOperation("编辑 - 座位信息")
  @PostMapping("/edit_seat")
  ReturnMessage<Void> edit_seat(@RequestBody GlobalAskBody<?> body);

  @ApiOperation("分页 - 参赛者对战记录")
  @PostMapping("/page_match_record")
  ReturnMessage<Page<?>> page_participant_record(@RequestBody GlobalAskBody<?> body);

  @ApiOperation("导出比赛")
  @PostMapping("/export_tournament")
  ReturnMessage<Void> export_tournament(@RequestBody GlobalAskBody<Long> body);

  @ApiOperation("导出比赛 - 单轮次")
  @PostMapping("/export_round")
  ReturnMessage<Void> export_round(@RequestBody GlobalAskBody<?> body);

  @ApiOperation("导入比赛 - 单轮次")
  @PostMapping("/import_round")
  ReturnMessage<Void> import_round(@RequestBody GlobalAskBody<?> body);
}
