package moe.mycard.tabulator.model.dto;

import java.util.List;

public class PaginatedReturnMessage<T> extends ReturnMessage<List<T>> {
  public Integer pageCount;
  public Integer recordsPerPage;
  public Integer total;
  public Integer totalPages;
  public PaginatedReturnMessage(Integer statusCode, String message, List<T> data, Integer total, PageSettingsWise pageSettings) {
    super(statusCode, message, data);
    this.total = total;
    this.pageCount = pageSettings.getPageCount();
    this.recordsPerPage = pageSettings.getRecordsPerPage();
    this.totalPages = (int) Math.ceil((double) total / (double) recordsPerPage);
  }
}
