package moe.mycard.tabulator.tool;

import com.alibaba.fastjson.JSON;
import moe.mycard.tabulator.model.epi.MyCardEPI;
import moe.mycard.tabulator.model.epi.ResponseEPI;
import okhttp3.Response;

import java.io.IOException;
import java.util.Objects;

/** 外部接口返回数据封装 */
public class UtilEPI {

  public static ResponseEPI<MyCardEPI> getMyCard(Response response) throws IOException {
    ResponseEPI<MyCardEPI> epi = new ResponseEPI<>();
    epi.setCode(response.code());
    epi.setData(
        JSON.parseObject(Objects.requireNonNull(response.body()).string(), MyCardEPI.class));
    return epi;
  }
}
