package moe.mycard.tabulator.model.service.ds;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.val;
import moe.mycard.tabulator.common.UserInfo;
import moe.mycard.tabulator.exception.CavCore;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.po.TournamentAssignPO;
import moe.mycard.tabulator.model.po.TournamentPO;
import moe.mycard.tabulator.model.service.ILogService;
import moe.mycard.tabulator.model.service.ITournamentAssignService;
import moe.mycard.tabulator.model.service.ITournamentService;
import moe.mycard.tabulator.model.vo.req.SaveTournamentReq;
import moe.mycard.tabulator.model.vo.req.TidReq;
import moe.mycard.tabulator.model.vo.req.UpdateTournamentReq;
import moe.mycard.tabulator.tool.UtilTime;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class IndexDoService {

  private final CavCore c = CavCore.getC();

  @Resource private ITournamentService tournamentService;
  @Resource private ITournamentAssignService tournamentAssignService;
  @Resource private ILogService logService;

  /**
   * 展示首页的比赛列表
   *
   * @return 比赛分页列表
   */
  public Page<TournamentPO> pageTournament(GlobalAskBody<?> body) {
    c.cn(body);

    val userId = UserInfo.getUserId();
    // TODO 展示权限过滤

    val authIdSet = tournamentAssignService.getMyAccessTId(userId);

    val page =
        tournamentService.page(
            body.buildPage(),
            new LambdaQueryWrapper<TournamentPO>()
                .in(TournamentPO::getTournamentId, authIdSet)
                .eq(TournamentPO::getIsValid, true));

    return page;
  }

  /**
   * 生成比赛信息
   *
   * @param body saveReq
   */
  public void saveTournament(GlobalAskBody<SaveTournamentReq> body) {
    c.cn(body);
    // ===== 主逻辑，生成比赛 =====
    TournamentPO savePO = new TournamentPO();
    BeanUtils.copyProperties(body.getParams(), savePO);
    savePO.setIsValid(true);
    savePO.setTimeCreate(UtilTime.getDateL());
    tournamentService.save(savePO);
    // ===== 主逻辑，生成比赛 =====

    // ===== 生成比赛权限
    tournamentAssignService.create(UserInfo.getUserId(), savePO.getTournamentId());

    // ===== 生成操作日志
    logService.create(UserInfo.getUserId(), "创建了比赛 " + savePO);
  }

  /**
   * 编辑比赛信息
   *
   * @param body updateReq
   */
  public void editTournament(GlobalAskBody<UpdateTournamentReq> body) {
    c.cn(body);
    val tid = body.getParams().getTournamentId();
    c.cn(tid, "比赛id为空");

    val userId = UserInfo.getUserId();
    val auth =
        tournamentAssignService.getOne(
            new LambdaQueryWrapper<TournamentAssignPO>()
                .select(TournamentAssignPO::getIsValid)
                .eq(TournamentAssignPO::getIsValid, true)
                .eq(TournamentAssignPO::getUserId, userId)
                .eq(TournamentAssignPO::getTournamentId, tid)
                .eq(TournamentAssignPO::getAuthEdit, true));

    c.cn(auth, "无权编辑");

    val updatePO = new TournamentPO();
    BeanUtils.copyProperties(body.getParams(), updatePO);
    updatePO.setTimeUpdate(UtilTime.getDateL());
    tournamentService.updateById(updatePO);

    // ===== 生成操作日志
    logService.create(userId, "编辑了比赛 " + updatePO);
  }

  /**
   * 删除比赛信息
   *
   * @param body 比赛id
   */
  public void deleteTournament(GlobalAskBody<TidReq> body) {
    c.cn(body);
    val tournamentId = body.getParams().getTournamentId();
    c.cn(tournamentId, "比赛id为空");

    val userId = UserInfo.getUserId();
    val auth =
        tournamentAssignService.getOne(
            new LambdaQueryWrapper<TournamentAssignPO>()
                .select(TournamentAssignPO::getIsValid)
                .eq(TournamentAssignPO::getIsValid, true)
                .eq(TournamentAssignPO::getUserId, userId)
                .eq(TournamentAssignPO::getTournamentId, tournamentId)
                .eq(TournamentAssignPO::getAuthDelete, true));

    c.cn(auth, "无权删除");

    val deletePO = new TournamentPO();
    deletePO.setTournamentId(tournamentId);
    deletePO.setTimeUpdate(UtilTime.getDateL());
    deletePO.setIsValid(false);
    tournamentService.updateById(deletePO);

    // ===== 生成操作日志
    logService.create(userId, "删除了比赛 " + deletePO);
  }
}
