package moe.mycard.tabulator.common;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

/**
 * 在springboot2.0.0之后，WebMvcConfigurerAdapter已经过时了 会使用WebMvcConfigurer或者WebMvcConfigurationSupport替代
 */
@Configuration
public class MvcConfigurer extends WebMvcConfigurationSupport {

  /** 由于拦截器的加载时间点在spring context之前，所以需要提前注入bean，否则拦截类内部注入注解会失效 */
  @Bean
  public LoginInterceptor getLoginInterceptor() {
    return new LoginInterceptor();
  }

  /**
   * 在springboot2.0.0之后继承WebMvcConfigurationSupport类，重写addInterceptors方法
   *
   * @param registry ~
   */
  @Override
  protected void addInterceptors(InterceptorRegistry registry) {
    /** 拦截器按照顺序执行,如果不同拦截器拦截存在相同的URL，前面的拦截器会执行，后面的拦截器将不执行 */
    registry.addInterceptor(getLoginInterceptor()).addPathPatterns("/**");
    super.addInterceptors(registry);
  }
}
