package moe.mycard.tabulator.model.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.val;
import moe.mycard.tabulator.model.mapper.TournamentAssignMapper;
import moe.mycard.tabulator.model.po.TournamentAssignPO;
import moe.mycard.tabulator.model.service.ITournamentAssignService;
import moe.mycard.tabulator.tool.UtilTime;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.Set;

/**
 * 主表 - 比赛子表 比赛授权关联表 服务实现类
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@Service
public class TournamentAssignServiceImpl
    extends ServiceImpl<TournamentAssignMapper, TournamentAssignPO>
    implements ITournamentAssignService {
  @Override
  public void create(Integer userId, Integer tId) {
    val time = UtilTime.getDateL();
    // ===== 比赛创建人权限 =====
    TournamentAssignPO savePO = new TournamentAssignPO();
    savePO.setTournamentId(tId);
    savePO.setUserId(userId);
    savePO.setAuthAccess(true);
    savePO.setAuthEdit(true);
    savePO.setAuthDelete(true);
    savePO.setTimeLimit(null);
    savePO.setTimeCreate(time);
    savePO.setAuthorUserId(userId);
    savePO.setIsValid(true);
    save(savePO);
    // ===== 比赛创建人权限 =====
  }

  @Override
  public Set<Integer> getMyAccessTId(Integer userId) {
    val list1 =
        list(
            new LambdaQueryWrapper<TournamentAssignPO>()
                .select(TournamentAssignPO::getTournamentId)
                .eq(TournamentAssignPO::getIsValid, true)
                .eq(TournamentAssignPO::getUserId, userId)
                .eq(TournamentAssignPO::getAuthAccess, true));

    val list2 =
        list(
            new LambdaQueryWrapper<TournamentAssignPO>()
                .select(TournamentAssignPO::getTournamentId)
                .eq(TournamentAssignPO::getIsValid, true)
                .eq(TournamentAssignPO::getUserId, -1)
                .eq(TournamentAssignPO::getAuthAccess, true));

    Set<Integer> result = new HashSet<>();
    list1.forEach(po -> result.add(po.getTournamentId()));
    list2.forEach(po -> result.add(po.getTournamentId()));

    return result;
  }
}
