package moe.mycard.tabulator.model.service;

import com.baomidou.mybatisplus.extension.service.IService;
import moe.mycard.tabulator.model.po.TournamentAssignPO;

import java.util.Set;

/**
 * 主表 - 比赛子表 比赛授权关联表 服务类
 *
 * @author SPiCa
 * @since 2022-03-23
 */
public interface ITournamentAssignService extends IService<TournamentAssignPO> {

  /**
   * 创建比赛，生成授权关系
   *
   * @param userId 创建者
   * @param tId 比赛ID
   */
  void create(Integer userId, Integer tId);

  /**
   * 获取我拥有的访问权限比赛ID
   *
   * @param userId 用户id
   * @return 比赛id集合
   */
  Set<Integer> getMyAccessTId(Integer userId);
}
