package moe.mycard.tabulator.model.po;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 主表 - 比赛子表 比赛授权关联表
 *
 * @author SPiCa
 * @since 2022-03-23
 */
@Data
@TableName("ta_tournament_assign")
@ApiModel(value = "TournamentAssign对象", description = "主表 - 比赛子表 比赛授权关联表")
public class TournamentAssignPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("授权 - 主键id")
    private Integer assignId;

    @ApiModelProperty("外键 >> 比赛 - 主键id")
    private Integer tournamentId;

    @ApiModelProperty("外键 >> 用户 - 主键id【-1 所有人】")
    private Integer userId;

    @ApiModelProperty("权限 - 是否可访问")
    private Boolean authAccess;

    @ApiModelProperty("权限 - 是否可修改")
    private Boolean authEdit;

    @ApiModelProperty("权限 - 是否可删除")
    private Boolean authDelete;

    @ApiModelProperty("时间 - 权限有效时间【null 永久】")
    private LocalDateTime timeLimit;

    @ApiModelProperty("时间 - 创建时间")
    private LocalDateTime timeCreate;

    @ApiModelProperty("时间 - 修改时间")
    private LocalDateTime timeUpdate;

    @ApiModelProperty("权限 - 创建人")
    private Integer authorUserId;

  @ApiModelProperty("是否有效")
  private Boolean isValid;
}
