package moe.mycard.tabulator.model.dto.tournament;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class SeatNode {

  @ApiModelProperty("座位id")
  private Integer seatId;

  @ApiModelProperty("主要数据")
  private SeatData data;

  @ApiModelProperty("下一组节点")
  private SeatNode[] next;

  @ApiModelProperty("上一组节点")
  private SeatNode[] previous;

  @ApiModelProperty("树深（从1开始）")
  private Integer depth;

  @ApiModelProperty("树深（从1开始） 倒叙")
  private Integer depthDesc;

  /**
   * 快速创建轮空位
   *
   * @param seatId 座位id
   * @param type 节点类型
   * @param depth 树深
   * @param depthDesc 树深倒叙
   * @param date 创建时间
   * @return 轮空位置
   */
  public static SeatNode vacancy(
      int seatId, int type, int depth, int depthDesc, LocalDateTime date) {
    SeatData nodeData = new SeatData();
    nodeData.setSeatId(seatId);
    nodeData.setParticipantId(null);
    nodeData.setDeck("轮空");
    nodeData.setLock(false);
    nodeData.setMatchType(0);
    nodeData.setDataType(2);
    nodeData.setTimeCreate(date);
    nodeData.setTimeMatch(null);

    SeatNode node = new SeatNode();
    node.setSeatId(nodeData.getSeatId());
    node.setData(nodeData);
    node.setNext(null);
    node.setPrevious(null);
    node.setDepth(depth);
    node.setDepthDesc(depthDesc);
    return node;
  }

  public static SeatNode emptySeat(
      int seatId, int depth, int depthDesc, LocalDateTime date, SeatNode[] pre) {
    SeatData nodeData = new SeatData();
    nodeData.setSeatId(seatId);
    nodeData.setParticipantId(null);
    nodeData.setDeck("");
    nodeData.setLock(false);
    nodeData.setMatchType(0);
    nodeData.setDataType(1);
    nodeData.setTimeCreate(date);
    nodeData.setTimeMatch(null);

    SeatNode node = new SeatNode();
    node.setSeatId(nodeData.getSeatId());
    node.setData(nodeData);
    node.setNext(null);
    node.setPrevious(pre);
    node.setDepth(depth);
    node.setDepthDesc(depthDesc);
    return node;
  }
}
