package moe.mycard.tabulator.model.dto.tournament;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class SeatData {

  @ApiModelProperty("座位id")
  private Integer seatId;

  @ApiModelProperty("参赛者主键id")
  private Integer participantId;

  @ApiModelProperty("卡组名称")
  private String deck;

  @ApiModelProperty("是否锁定")
  private Boolean lock;

  @ApiModelProperty("对局类型【0 准备阶段】【1 已结束对局】")
  private Integer matchType;

  @ApiModelProperty("数据类型【1 初始化数据 or 导入数据】【2 系统推算数据】【3 人为编辑数据】")
  private Integer dataType;

  @ApiModelProperty("时间 - 创建时间")
  private LocalDateTime timeCreate;

  @ApiModelProperty("时间 - 座位对局时间")
  private LocalDateTime timeMatch;

  @ApiModelProperty("对局比分")
  private Integer matchFraction;

  @ApiModelProperty("对局备注")
  private String matchRemark;

  @ApiModelProperty("对局id")
  private Integer matchId;
}
