package moe.mycard.tabulator.controllers;

import lombok.val;
import moe.mycard.tabulator.api.TournamentApi;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.dto.ReturnMessage;
import moe.mycard.tabulator.model.dto.tournament.TTree;
import moe.mycard.tabulator.model.po.TournamentPO;
import moe.mycard.tabulator.model.service.ds.IndexDoService;
import moe.mycard.tabulator.model.service.ds.TournamentDoService;
import moe.mycard.tabulator.model.vo.req.ImportParticipantPO;
import moe.mycard.tabulator.model.vo.req.TidReq;
import moe.mycard.tabulator.model.vo.req.UpdateSeatNode;
import moe.mycard.tabulator.model.vo.req.UpdateTournamentReq;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
public class TournamentDo implements TournamentApi {

  @Resource private TournamentDoService tournamentDoService;

  @Resource private IndexDoService indexDoService;

  @Override
  public ReturnMessage<Integer> edit_import_participant(GlobalAskBody<ImportParticipantPO> body) {
    val count = tournamentDoService.importParticipant(body);
    return ReturnMessage.data(count);
  }

  @Override
  public ReturnMessage<TTree> tabulation(GlobalAskBody<TidReq> body) {
    val table = tournamentDoService.tabulation(body);
    return ReturnMessage.data(table);
  }

  @Override
  public ReturnMessage<?> edit_tournament(GlobalAskBody<UpdateTournamentReq> body) {
    indexDoService.editTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<TournamentPO> details_tournament_info(GlobalAskBody<TidReq> body) {
    val data = tournamentDoService.tournamentInfo(body);
    return ReturnMessage.data(data);
  }

  @Override
  public ReturnMessage<String> details_tournament_tree(GlobalAskBody<TidReq> body) {
    val data = tournamentDoService.tournamentInfo(body);
    return ReturnMessage.data(data == null ? null : data.getTournamentSeat());
  }

  @Override
  public ReturnMessage<?> edit_seat(GlobalAskBody<UpdateSeatNode> body) {
    tournamentDoService.editSeat(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<?> promotion(GlobalAskBody<TidReq> body) {
    return null;
  }

  //  @Override
  //  public ReturnMessage<Page<?>> page_participant_record(GlobalAskBody<?> body) {
  //    return null;
  //  }

  //  @Override
  //  public ReturnMessage<TTree> export_tournament(GlobalAskBody<Integer> body) {
  //    return null;
  //  }

  //  @Override
  //  public ReturnMessage<?> export_round(GlobalAskBody<?> body) {
  //    return null;
  //  }
  //
  //  @Override
  //  public ReturnMessage<?> import_round(GlobalAskBody<?> body) {
  //    return null;
  //  }
}
