package moe.mycard.tabulator.controllers;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.val;
import moe.mycard.tabulator.api.IndexApi;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.dto.ReturnMessage;
import moe.mycard.tabulator.model.po.TournamentPO;
import moe.mycard.tabulator.model.service.ds.IndexDoService;
import moe.mycard.tabulator.model.service.ds.TournamentDoService;
import moe.mycard.tabulator.model.vo.req.SaveTournamentReq;
import moe.mycard.tabulator.model.vo.req.TidReq;
import moe.mycard.tabulator.model.vo.req.UpdateTournamentReq;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
public class IndexDo implements IndexApi {

  @Resource private IndexDoService indexService;

  @Resource private TournamentDoService tournamentDoService;

  @Override
  public ReturnMessage<?> save_tournament(GlobalAskBody<SaveTournamentReq> body) {
    indexService.saveTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<Page<TournamentPO>> page_tournament(GlobalAskBody<?> body) {
    val page = indexService.pageTournament(body);
    return ReturnMessage.data(page);
  }

  @Override
  public ReturnMessage<?> edit_tournament(GlobalAskBody<UpdateTournamentReq> body) {
    indexService.editTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<?> delete_tournament(GlobalAskBody<TidReq> body) {
    indexService.deleteTournament(body);
    return ReturnMessage.ok();
  }

  @Override
  public ReturnMessage<TournamentPO> details_tournament_info(GlobalAskBody<TidReq> body) {
    val data = tournamentDoService.tournamentInfo(body);
    return ReturnMessage.data(data);
  }

  @Override
  public ReturnMessage<?> export_tournament(GlobalAskBody<TidReq> body) {
    return null;
  }

  @Override
  public ReturnMessage<?> authorize(GlobalAskBody<?> body) {
    return null;
  }
}
