package moe.mycard.tabulator.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import moe.mycard.tabulator.model.dto.GlobalAskBody;
import moe.mycard.tabulator.model.dto.ReturnMessage;
import moe.mycard.tabulator.model.dto.tournament.TTree;
import moe.mycard.tabulator.model.po.TournamentPO;
import moe.mycard.tabulator.model.vo.req.ImportParticipantPO;
import moe.mycard.tabulator.model.vo.req.TidReq;
import moe.mycard.tabulator.model.vo.req.UpdateSeatNode;
import moe.mycard.tabulator.model.vo.req.UpdateTournamentReq;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags = "比赛相关接口")
@RequestMapping(TournamentApi.api)
public interface TournamentApi {

  String api = ApiEnum.api + "/tournament";

  @ApiOperation("编辑 - 导入参赛信息")
  @PostMapping("/edit_import_participant")
  ReturnMessage<Integer> edit_import_participant(
      @RequestBody GlobalAskBody<ImportParticipantPO> body);

  @ApiOperation("制表")
  @PostMapping("tabulation")
  ReturnMessage<TTree> tabulation(@RequestBody GlobalAskBody<TidReq> body);

  @ApiOperation("编辑 - 单场次比赛信息")
  @PostMapping("/edit_tournament")
  ReturnMessage<?> edit_tournament(@RequestBody GlobalAskBody<UpdateTournamentReq> body);

  @ApiOperation("详情 - 单场次比赛信息 常规信息")
  @PostMapping("/details_tournament_info")
  ReturnMessage<TournamentPO> details_tournament_info(@RequestBody GlobalAskBody<TidReq> body);

  @ApiOperation("详情 - 单场次比赛信息 树形对战信息")
  @PostMapping("/details_tournament_tree")
  ReturnMessage<String> details_tournament_tree(@RequestBody GlobalAskBody<TidReq> body);

  @ApiOperation("编辑 - 座位信息")
  @PostMapping("/edit_seat")
  ReturnMessage<?> edit_seat(@RequestBody GlobalAskBody<UpdateSeatNode> body);

  @ApiOperation("晋级")
  @PostMapping("/promotion")
  ReturnMessage<?> promotion(@RequestBody GlobalAskBody<TidReq> body);

  //  @ApiOperation("分页 - 参赛者对战记录")
  //  @PostMapping("/page_match_record")
  //  ReturnMessage<Page<?>> page_participant_record(@RequestBody GlobalAskBody<?> body);

  //  @ApiOperation("导出比赛")
  //  @PostMapping("/export_tournament")
  //  ReturnMessage<TTree> export_tournament(@RequestBody GlobalAskBody<Integer> body);

  //  @ApiOperation("导出比赛 - 单轮次")
  //  @PostMapping("/export_round")
  //  ReturnMessage<?> export_round(@RequestBody GlobalAskBody<?> body);

  //  @ApiOperation("导入比赛 - 单轮次")
  //  @PostMapping("/import_round")
  //  ReturnMessage<?> import_round(@RequestBody GlobalAskBody<?> body);
}
