package moe.mycard.tabulator;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

import java.util.Collections;

/** 代码生成器 */
public class MysqlGenerator {

  public static void main(String[] args) {
    try {
      FastAutoGenerator.create("jdbc:mysql://localhost:3306/ygo_table", "root", "123456")
          .globalConfig(
              builder -> {
                // 设置作者
                builder
                    .author("SPiCa")
                    .enableSwagger() // 开启 swagger 模式
                    .outputDir(
                        "D:\\project\\web\\tabulator\\src\\main\\java\\moe\\mycard\\tabulator\\temp"); // 指定输出目录
              })
          .packageConfig(
              builder -> {
                builder
                    .parent("") // 设置父包名
                    .moduleName("") // 设置父包模块名
                    .entity("po")
                    .service("service")
                    .serviceImpl("service.impl")
                    .mapper("mapper")
                    .xml("mapper.xml")
                    .pathInfo(
                        Collections.singletonMap(
                            OutputFile.xml,
                            "D:\\project\\web\\tabulator\\src\\main\\resources\\mapper")); // 设置mapperXml生成路径
              })
          .strategyConfig(
              builder -> {
                builder
                    .addInclude("core_config") // 设置需要生成的表名
                    .addInclude("ta_log") // 设置需要生成的表名
                    .addInclude("ta_match") // 设置需要生成的表名
                    .addInclude("ta_participant") // 设置需要生成的表名
                    .addInclude("ta_seat_record") // 设置需要生成的表名
                    .addInclude("ta_tournament") // 设置需要生成的表名
                    .addInclude("ta_tournament_assign") // 设置需要生成的表名
                    .addInclude("ta_user") // 设置需要生成的表名
                    .addTablePrefix("ta_", "core_"); // 设置过滤表前缀
              })
          .templateEngine(new FreemarkerTemplateEngine()) // 使用Freemarker引擎模板，默认的是Velocity引擎模板
          .execute();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
