#include <iostream>
#include <thread>
#include <sys/socket.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <linux/if.h>
#include <linux/ip.h>
#include <linux/if_tun.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <boost/program_options.hpp>

#define decrypt_package encrypt_package

namespace po = boost::program_options;

in_addr_t remote;
auto cipher = (unsigned char *) "Mathematics is the art of giving the same name to different things.";

void encrypt_package(unsigned char *buffer, size_t length) {
    for (auto i = 0; i < length; i++) {
        buffer[i] ^= cipher[i];
    }
}

// internet -> tun
void inbound(int raw, int tun) {
    unsigned char buffer[ETH_DATA_LEN];
    sockaddr_in address{.sin_family = AF_INET};
    socklen_t address_length;
    size_t packet_length;
    while ((packet_length = recvfrom(raw, buffer, sizeof(buffer), 0, (sockaddr *) &address, &address_length)) >= 0) {
//        std::cout << "received " << packet_length << " bytes from " << inet_ntoa(address.sin_addr) << std::endl;
        auto *packet = (iphdr *) buffer;
        auto overhead = packet->ihl * 4;
        auto payload = buffer + overhead;
        auto payload_length = packet_length - overhead;
        decrypt_package(payload, payload_length);
        if (write(tun, payload, payload_length) < 0) {
            perror("inbound write");
        }
    }
    perror("inbound read");
}

// tun -> internet
void outbound(int raw, int tun) {
    unsigned char buffer[ETH_DATA_LEN];
    sockaddr_in address{.sin_family = AF_INET};
    address.sin_addr.s_addr = remote;
    size_t packet_length;
    while ((packet_length = read(tun, buffer, sizeof(buffer))) >= 0) {
        encrypt_package(buffer, packet_length);
        if (sendto(raw, buffer, packet_length, 0, (sockaddr *) &address, sizeof(address)) < 0) {
            perror("outbound write");
        }
    }
    perror("outbound read");
}

int main(int argc, char *argv[]) {

    po::options_description desc("Allowed options");
    desc.add_options()
            ("help,h", "see how to use me elegantly")
            ("IP,i", po::value<std::string>(), "IP to connect")
            ("dev,d", po::value<std::string>(), "tunnel device's name")
            ("postup,p", po::value<std::string>(), "post up script");

    po::variables_map args;
    po::store(po::parse_command_line(argc, argv, desc), args);
    po::notify(args);

    if (args.count("help") || !args.count("IP") || !args.count("dev")) {
        std::cout << desc << std::endl;
        return -1;
    }

    ifreq ifr{};
    ifr.ifr_flags = IFF_TUN | IFF_NO_PI;
    strncpy(ifr.ifr_name, args["dev"].as<std::string>().c_str(), IFNAMSIZ);
    remote = inet_addr(args["IP"].as<std::string>().c_str());

    auto raw = socket(AF_INET, SOCK_RAW, IPPROTO_IPIP);
    if (raw < 0) {
        perror("socket init error");
        return -1;
    }
    auto tun = open("/dev/net/tun", O_RDWR);
    if (tun < 0) {
        perror("tun init error");
        return -1;
    }

    if (ioctl(tun, TUNSETIFF, &ifr) < 0) {
        perror("ioctl error");
        return -1;
    }

    if (args.count("postup")) {
        system(args["postup"].as<std::string>().c_str());
    }

    std::thread t1(inbound, raw, tun);
    std::thread t2(outbound, raw, tun);
    t1.join();
    t2.join();

    return 0;
}
