#!/bin/bash

pid=0

run_stop() {
  signalCode=$1
  if [ -n "$DOWN_SCRIPT" ]; then
    eval "$DOWN_SCRIPT"
  fi
  if [ $pid -ne 0 ]; then
    kill "-$signalCode" "$pid"
    wait "$pid"
  fi
  echo "Stopped"
  exit $((128 + signalCode));
}

trap 'kill ${!}; run_stop 2' SIGTERM
trap 'kill ${!}; run_stop 15' SIGINT

echo "Started"
"$@" &
pid="$!"

# wait forever
while true
do
  tail -f /dev/null & wait ${!}
done
