#include <iostream>
#include <thread>
#include <sys/socket.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <linux/if.h>
#include <linux/ip.h>
#include <linux/if_tun.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <cstring>

struct Meta {
    unsigned char src_id;
    unsigned char dst_id;
    unsigned short reversed;
};

unsigned char local_id;
unsigned char remote_id;
sockaddr_storage remote_addr{};

class Secret {
private:
    char *key;
    size_t length;
public:
    Secret(char *key) : key(key), length(strlen(key)) {}

    void encrypt(unsigned char *data, size_t length) {
        for (size_t i = 0; i < length; i++) {
            data[i] ^= key[i % this->length];
        }
    }

    void decrypt(unsigned char *data, size_t length) {
        encrypt(data, length);
    }
};

Secret *localSecret;
Secret *remoteSecret;

#include <linux/ipv6.h>
#include <vector>


// internet -> tun
void inbound(int raw, int tun) {
    unsigned char buffer[ETH_DATA_LEN];
    sockaddr_storage address;
    socklen_t address_length = sizeof(address);
    size_t packet_length;
    while ((packet_length = recvfrom(raw, buffer, sizeof(buffer), 0, (sockaddr *) &address, &address_length)) >= 0) {
        auto *packet = (iphdr *) buffer;
        auto overhead = packet->ihl * 4;
        auto payload = buffer + overhead;
        auto meta = (Meta *) payload;
        if (!(meta->src_id == remote_id && meta->dst_id == local_id && meta->reversed == 0)) continue;
        auto inner = (payload + sizeof(Meta));
        auto payload_length = packet_length - overhead - sizeof(Meta);
        remoteSecret->decrypt(inner, payload_length);
        switch (((ipv6hdr *) inner)->version) {
            case 4:
                if (csum((uint16_t *) inner, ((iphdr *) inner)->ihl * 4)) continue;
                break;
            case 6:
                // ipv6 don't have checksum, do nothing
                break;
            default:
                continue;
        }
//        if (ip_fast_csum(inner, inner->ihl)) continue;
//        std::cout << "packet_length " << packet_length
//                  << " tot_len " << ntohs(packet->tot_len)
//                  << " inner->tot_len " << ntohs(inner->tot_len)
//                  << " from " << inet_ntoa(address.sin_addr) << std::endl;
//        if (remote_addr.sin_addr.s_addr != address.sin_addr.s_addr) {
//            std::cout << "float ip: " << inet_ntoa(address.sin_addr) << std::endl;
//        }
        remote_addr = address;

        if (write(tun, inner, payload_length) < 0) {
            perror("inbound write");
        }
    }
    perror("inbound read");
}

// tun -> internet
void outbound(int raw, int tun) {
    unsigned char buffer[ETH_DATA_LEN];
    auto meta = (Meta *) buffer;
    meta->src_id = local_id;
    meta->dst_id = remote_id;
    meta->reversed = 0;
    auto inner = buffer + sizeof(Meta);
    size_t packet_length;
    while ((packet_length = read(tun, inner, sizeof(buffer) - sizeof(Meta))) >= 0) {
//        std::cout << "sendto: " << inet_ntoa(remote_addr.sin_addr) << std::endl;
        if (!remote_addr.ss_family) continue;
        localSecret->encrypt(inner, packet_length);
        if (sendto(raw, buffer, packet_length + sizeof(Meta), 0, (sockaddr *) &remote_addr, sizeof(remote_addr)) <
            0) {
            perror("outbound write");
        }
    }
    perror("outbound read");
}







int main(int argc, char *argv[]) {
//    json data = json::parse(argv[1]);
//    auto config = data.get<Config>();
//
//
//    if (endpoint != nullptr) {
//        addrinfo hints = {
//                .ai_family = family
//        };
//        addrinfo *result;
//
//        auto ret = getaddrinfo(endpoint, nullptr, &hints, &result);
//        if (ret != 0) {
//            puts(gai_strerror(ret));
//            return -1;
//        }
//        remote_addr = *(sockaddr_storage *) result->ai_addr;
//        freeaddrinfo(result);           /* No longer needed */
//    }
//    ifreq ifr{};
//    ifr.ifr_flags = IFF_TUN | IFF_NO_PI;
//    strncpy(ifr.ifr_name, dev, IFNAMSIZ);
//
//    auto raw = socket(family, SOCK_RAW, proto);
//    if (raw < 0) {
//        perror("socket init error");
//        return -1;
//    }
//    if (mark) {
//        if (setsockopt(raw, SOL_SOCKET, SO_MARK, &mark, sizeof(mark)) < 0) {
//            perror("setsockopt error");
//            return -1;
//        }
//    }
//    auto tun = open("/dev/net/tun", O_RDWR);
//    if (tun < 0) {
//        perror("tun init error");
//        return -1;
//    }
//    puts(dev);
//
//    if (ioctl(tun, TUNSETIFF, &ifr) < 0) {
//        perror("ioctl error");
//        return -1;
//    }
//
//    system(up);
//
//    std::thread t1(inbound, raw, tun);
//    std::thread t2(outbound, raw, tun);
//    t1.join();
//    t2.join();

    return 0;
}
