#include <nlohmann/json.hpp>

using json = nlohmann::json;

struct ConfigRouter {
    unsigned char remote_id;
    unsigned char proto;
    unsigned char mark;
    unsigned char family;
    std::string remote_secret;
    std::string dev;
    std::string up;
    std::string endpoint;
};

struct Config {
    unsigned char local_id;
    std::string local_secret;
    std::vector<ConfigRouter> routers;
};

void from_json(const json& j, ConfigRouter& p) {
    j.at("remote_id").get_to(p.remote_id);
    j.at("proto").get_to(p.proto);
    j.at("mark").get_to(p.mark);
    j.at("family").get_to(p.family);
    j.at("remote_secret").get_to(p.remote_secret);
    j.at("dev").get_to(p.dev);
    j.at("up").get_to(p.up);
    j.at("endpoint").get_to(p.endpoint);
}

void from_json(const json& j, Config& p) {
    j.at("local_id").get_to(p.local_id);
    j.at("local_secret").get_to(p.local_secret);
    j.at("routers").get_to(p.routers);
}
