#!/bin/bash
INTERFACE=$1
TARGET=$2

if [[ -z "$TARGET" ]]; then
  TARGET=wg
fi

COMMAND="flush interface ${INTERFACE}\nquit"
COMMAND_BASE64=$(echo -e "$COMMAND" | base64 -w 0)

cd ansible
ansible "$TARGET" -m shell -b -a "wg-quick down ${INTERFACE} ; echo $COMMAND_BASE64 | base64 --decode | timeout 1 nc ::1 33123"
ansible "$TARGET" -m systemd -b -a "name=wg-quick@${INTERFACE} state=stopped enabled=false"
ansible "$TARGET" -m docker_compose -a "project_src=~/nextgen-network/services services=openconnect-${INTERFACE} stopped=true"
cd ..
