#!/bin/bash

pid=0
down=$(echo "$1" | jq -r '.routers | .[].down')
echo "$down"
run_stop() {
  signalCode=$1
  if [ -n "$down" ]; then
    eval "$down"
  fi
  if [ $pid -ne 0 ]; then
    kill "-$signalCode" "$pid"
    wait "$pid"
  fi
  exit $((128 + signalCode));
}

trap 'kill ${!}; run_stop 2' SIGTERM
trap 'kill ${!}; run_stop 15' SIGINT

tun "$@" &
pid="$!"

# wait forever
wait "$pid"
pid=0
run_stop 1
