use socket2::{Domain, Protocol, SockAddr, Socket, Type};
use std::error::Error;
use std::io::{BufRead, Read, Write};
use std::mem::MaybeUninit;
use std::{env, thread};
use std::net::SocketAddrV4;

#[repr(C)]
pub struct Meta {
    pub src_id: u8,
    pub dst_id: u8,
    pub reversed: u16,
}

struct Secret {
    key: Vec<u8>,
}

impl Secret {
    fn new(key: &String) -> Secret {
        Secret {
            key: key.as_bytes().to_vec(),
        }
    }
    fn encrypt(&self, data: &mut [u8]) {
        for (i, byte) in data.iter_mut().enumerate() {
            *byte ^= self.key[i % self.key.len()];
        }
    }

    fn decrypt(&self, data: &mut [u8]) {
        self.encrypt(data);
    }
}

fn main() -> Result<(), Box<dyn Error>> {
    let local_id: u8 = env::var("LOCAL_ID")?.parse()?;
    let remote_id: u8 = env::var("REMOTE_ID")?.parse()?;
    let local_secret = Secret::new(&env::var("LOCAL_SECRET")?);
    let remote_secret = Secret::new(&env::var("REMOTE_SECRET")?);
    let mut remote_address: &SockAddr;

    let mut config = tun::Configuration::default();
    config
        .address((10, 0, 0, 9))
        .netmask((255, 255, 255, 0))
        .destination((10, 0, 0, 1))
        .up();

    #[cfg(target_os = "linux")]
    config.platform_config(|config| {
        config.ensure_root_privileges(true);
    });

    let dev = tun::create(&config)?;
    let (mut reader, writer) = dev.split();

    // 创建用于接收的原始套接字，协议号为 144
    let socket = Socket::new(Domain::IPV4, Type::RAW, Some(Protocol::from(144)))?;

    let inbound = thread::spawn(move || {
        let mut recv_buf = [MaybeUninit::uninit(); 1500];
        let mut addr: SockAddr;
        loop {
            match socket.recv_from(&mut recv_buf) {
                Ok((len, addr1)) => {
                    remote_address = &addr1;
                    println!("recv from {:?}", recv_buf);
                    // if let Some(packet) = Ipv4Packet::new(unsafe { transmute(&recv_buf[..len]) }) {
                    //     let (meta1, payload) = packet.payload().split_at_mut(size_of::<Meta>());
                    //     let meta: &Meta = unsafe { transmute(&meta1) };
                    //     if meta.src_id == remote_id && meta.dst_id == local_id && meta.reversed == 0
                    //     {
                    //         addr = addr1;
                    //         remote_secret.encrypt(payload);
                    //         writer.write_all(payload);
                    //     }
                    // }
                }
                Err(e) => {
                    eprintln!("接收数据包时出错: {:?}", e);
                }
            }
        }
    });

    let outbound = thread::spawn(move || {
        let mut recv_buf = [0u8; 1500-20-4];
        loop {
            match reader.read(&mut recv_buf) {
                Ok(len) => {
                    println!("recv from {:?}", recv_buf);

                    socket.send_to(&recv_buf, &remote_address);
                }
                Err(_) => {}
            }
        }
    });

    inbound.join();
    outbound.join();
    
    Ok(())
}
