#include <iostream>
#include <thread>

#include <sys/socket.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <linux/if.h>
#include <linux/ip.h>
#include <linux/if_tun.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <arpa/inet.h>

in_addr_t remote;

// internet -> tun
void inbound(int raw, int tun) {
    char buf[ETH_DATA_LEN];
    sockaddr_in address{.sin_family = AF_INET};
    socklen_t address_length;
    size_t packet_length;
    while ((packet_length = recvfrom(raw, buf, sizeof(buf), 0, (sockaddr *) &address, &address_length)) >= 0) {
//        std::cout << "received " << packet_length << " bytes from " << inet_ntoa(address.sin_addr) << std::endl;
        auto *packet = (iphdr *) buf;
        auto overhead = packet->ihl * 4;
        if (write(tun, buf + overhead, packet_length - overhead) < 0) {
            perror("inbound write");
        }
    }
    perror("inbound read");
}

// tun -> internet
void outbound(int raw, int tun) {
    char buf[ETH_DATA_LEN];
    sockaddr_in address{.sin_family = AF_INET};
    address.sin_addr.s_addr = remote;
    size_t packet_length;
    while ((packet_length = read(tun, buf, sizeof(buf))) >= 0) {
        if (sendto(raw, buf, packet_length, 0, (sockaddr *) &address, sizeof(address)) < 0) {
            perror("outbound write");
        }
    }
    perror("outbound read");
}

void show_usage() {
    printf("Usage Help:\n\n");
    printf("-i <IP>: IP to connect\n");
    printf("-h: show this usage help");
    return;
}

int main(int argc, char *argv[]) {
    
    if(argc <= 1){
        printf("Wrong usage! Type -h to see usage help.");
        return 0;
    }
    if(argv[1] == "-h"){
        show_usage();
        return 0;
    }
    if(argv[1] == "-i"){
        ifreq ifr{};
        ifr.ifr_flags = IFF_TUN | IFF_NO_PI;

        auto raw = socket(AF_INET, SOCK_RAW, IPPROTO_IPIP);
        if(raw < 0){
            perror("socket init error");
            return -1;
        }
        auto tun = open("/dev/net/tun", O_RDWR);
        if(tun < 0){
            perror("tun init error");
            return -1;
        }
    
        if(ioctl(tun, TUNSETIFF, &ifr) < 0){
            perror("ioctl error");
            return -1;
        }

        remote = inet_addr(argv[2]);

        std::cout << raw << std::endl;
        std::cout << tun << std::endl;

        std::thread t1(inbound, raw, tun);
        std::thread t2(outbound, raw, tun);
        t1.join();
        t2.join();
        
        return 0;
    }
    else {
        printf("Wrong usage! Type -h to see usage help.");
        return 0;
    }
}
