#!/bin/bash

pid=0

downs=()

if [ "${1:-}" = "-c" ] || [ "${1:-}" = "--config" ]; then
  config_file="$2"
  # 从文件直接 cat 管道给 jq
  while IFS= read -r d; do
    downs+=("$d")
  done < <(cat "$config_file" | jq -r '.routers[].down')
else
  # 直接把参数当作 JSON 字符串传给 jq，不存到变量
  while IFS= read -r d; do
    downs+=("$d")
  done < <(printf '%s' "$1" | jq -r '.routers[].down')
fi

echo "$down"
run_stop() {
  signalCode=$1
  for down in "${downs[@]}"; do
    eval "$down"
  done
  if [ $pid -ne 0 ]; then
    kill "-$signalCode" "$pid"
    wait "$pid"
  fi
  exit $((128 + signalCode));
}

trap 'kill ${!}; run_stop 2' SIGTERM
trap 'kill ${!}; run_stop 15' SIGINT

tun "$@" &
pid="$!"

# wait forever
wait "$pid"
pid=0
run_stop 1
