#!/usr/bin/env bash
set -e

ip addr add "$localPeerAddress" peer "$remotePeerAddress" dev "$dev"

if [ "$inbound" != True ] ; then
  ip route add default dev "$dev" table "$remoteMark"
  ip rule add fwmark "$remoteMark" table "$remoteMark" pref 300
fi

if [ -z "${mtu}" ]; then
    mtu=$(cat /sys/class/net/"$dev"/mtu)
fi

mss=$((mtu - 40))

iptables -t mangle -A FORWARD -i "$dev" -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss $mss:1460 -j TCPMSS --set-mss $mss
iptables -t mangle -A FORWARD -o "$dev" -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss $mss:1460 -j TCPMSS --set-mss $mss

iptables -t mangle -A PREROUTING -i "$dev" -m set ! --match-set mycard src -j CONNMARK --set-xmark "$remoteMark"
iptables -t mangle -A PREROUTING -m connmark --mark "$remoteMark" -j CONNMARK --restore-mark
iptables -t mangle -A OUTPUT -m connmark --mark "$remoteMark" -j CONNMARK --restore-mark
