#!/usr/bin/env bash

if [ "$outbound" == True ] ; then
  ip rule del fwmark "$remoteMark" table "$remoteMark" pref 300
fi

#if [ -z "${mtu}" ]; then
#    mtu=$(cat /sys/class/net/"$dev"/mtu)
#fi

mss=$((mtu - 40))

iptables -t mangle -D FORWARD -i "$dev" -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss $mss:1460 -j TCPMSS --set-mss $mss
iptables -t mangle -D FORWARD -o "$dev" -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss $mss:1460 -j TCPMSS --set-mss $mss

iptables -t mangle -D PREROUTING -i "$dev" -m set ! --match-set mycard src -j CONNMARK --set-xmark "$remoteMark"
iptables -t mangle -D PREROUTING -m connmark --mark "$remoteMark" -j CONNMARK --restore-mark
iptables -t mangle -D OUTPUT -m connmark --mark "$remoteMark" -j CONNMARK --restore-mark

# predown 始终返回成功。
true
