#!/usr/bin/env bash
set -e

if [ "$inbound" != true ] ; then
  ip rule del fwmark "$remoteMark" table "$remoteMark" pref 300
fi

if [ -z "${mtu}" ]; then
    mtu=$(cat /sys/class/net/%i/mtu)
fi

mss=$((mtu - 40))

iptables -t mangle -D FORWARD -i %i -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss $mss:1460 -j TCPMSS --set-mss $mss
iptables -t mangle -D FORWARD -o %i -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss $mss:1460 -j TCPMSS --set-mss $mss

iptables -t mangle -D PREROUTING -i %i -m set ! --match-set mycard src -j CONNMARK --set-xmark "$remoteMark"
iptables -t mangle -D PREROUTING -m connmark --mark "$remoteMark" -j CONNMARK --restore-mark
iptables -t mangle -D OUTPUT -m connmark --mark "$remoteMark" -j CONNMARK --restore-mark
