// use crate::router::RouterData;
// use serde::{Deserialize, Serialize}; // We will define this in router.rs
//
// #[derive(Debug, Clone, Serialize, Deserialize)]
// pub struct GatewayGroup {
//     pub id: u8,
//     pub name: String,
//     pub location_prefix: Vec<String>, // "locationPrefix" in JSON
//     pub include_routers: Vec<String>, // "includeRouters"
//     pub exclude_routers: Vec<String>, // "excludeRouters"
//     pub children: Vec<String>,
//     #[serde(skip)]
//     pub routers: Vec<u8>, // Calculated field
// }
//
// impl GatewayGroup {
//     pub fn new(
//         data: GatewayGroup,
//         all_groups: &[GatewayGroup],
//         all_routers: &[RouterData],
//     ) -> Self {
//         let mut group = data;
//         group.routers = Self::group_routers(&group, all_groups, all_routers);
//         group
//     }
//
//     pub fn group_routers(
//         group: &GatewayGroup,
//         all_groups: &[GatewayGroup],
//         all_routers: &[RouterData],
//     ) -> Vec<u8> {
//         let mut router_ids = Vec::new();
//
//         // 1. Filter by location prefix
//         for router in all_routers {
//             for prefix in &group.location_prefix {
//                 if router.location.starts_with(prefix) {
//                     router_ids.push(router.id);
//                 }
//             }
//         }
//
//         // 2. Include routers
//         for router in all_routers {
//             if group.include_routers.contains(&router.name) {
//                 router_ids.push(router.id);
//             }
//         }
//
//         // 3. Exclude routers
//         router_ids.retain(|id| {
//             let name = all_routers.iter().find(|r| r.id == *id).map(|r| &r.name);
//             if let Some(name) = name {
//                 !group.exclude_routers.contains(name)
//             } else {
//                 true
//             }
//         });
//
//         // 4. Recursive children
//         for child_name in &group.children {
//             if let Some(child_group) = all_groups.iter().find(|g| g.name == *child_name) {
//                 let child_routers = Self::group_routers(child_group, all_groups, all_routers);
//                 router_ids.extend(child_routers);
//             }
//         }
//
//         router_ids.sort_unstable();
//         router_ids.dedup();
//         router_ids
//     }
// }
