#![allow(dead_code)]

use bincode::{Decode, Encode};
use serde::Serialize;
use std::collections::BTreeMap;

use crate::shared::data::{GatewayGroupID, GatewayID, RegionID, RouterID};

#[derive(Encode, Decode)]
pub struct Hello {
    pub time: u32,
}

#[derive(Encode, Decode, Default, Debug, Eq, PartialEq, Copy, Clone)]
pub enum MessageType {
    #[default]
    Query,
    Full,
    Update,
}

#[derive(Encode, Decode, Default, Debug, Clone)]
pub struct Uplink {
    pub id: RouterID,
    pub action: MessageType,
    pub version: u32,
    pub peers: Vec<PeerQuality>,
    pub via: BTreeMap<RouterID, RouterID>,
    pub plan: BTreeMap<RegionID, BTreeMap<GatewayGroupID, GatewayID>>,
}

#[derive(Encode, Decode, Default, Debug, Clone)]
pub struct Downlink {
    pub action: MessageType,
    pub version: u32,
    pub ack: u32,
    pub via: BTreeMap<RouterID, RouterID>,
    pub plan: BTreeMap<RegionID, BTreeMap<GatewayGroupID, GatewayID>>,
}

#[derive(Encode, Decode, Serialize, Copy, Clone, Debug, Default)]
pub struct PeerQuality {
    pub delay: i16,
    pub reliability: u8,
    pub jitter: u8,
}
