use ::config::{Config, Environment};
use serde::Deserialize;
use std::net::SocketAddr;
use std::time::Duration;

#[derive(Deserialize)]
pub struct Settings {
    pub udp_bind: SocketAddr,
    pub http_bind: SocketAddr,
}

pub const TIMEOUT: Duration = Duration::from_secs(20);
pub const HALF_LIFE: Duration = Duration::from_secs(60);
pub const PENALTY: i32 = 100;
pub const PENALTY_MIN: i32 = 10;

pub static CONFIG: std::sync::LazyLock<Settings> = std::sync::LazyLock::new(|| Config::builder().add_source(Environment::default()).build().unwrap().try_deserialize().unwrap());
