use crate::shared::protocol::PeerQuality;
use serde::{Deserialize, Serialize};

#[derive(Debug, Clone, Copy, Serialize, Deserialize)]
pub struct Quality {
    pub delay: i32,
    pub jitter: u32,
    pub reliability: f32,
    pub cost: u32,
}

impl Quality {
    pub fn concat(&mut self, next: &PeerQuality, cost: u32) {
        self.delay += next.delay as i32;
        self.jitter += next.jitter as u32;
        self.reliability *= next.reliability as f32 / 64.0;
        self.cost += cost;
    }

    pub fn metric(&self) -> i32 {
        self.delay + ((1.0 - self.reliability) * 4000.0).round() as i32 + self.cost as i32
    }
}

impl Default for Quality {
    fn default() -> Self {
        Self {
            delay: 0,
            jitter: 0,
            reliability: 1.0,
            cost: 0,
        }
    }
}
