use axum::{Json, routing::get};
use serde::Serialize;
use std::collections::BTreeMap;
use std::sync::Arc;
use tokio::sync::RwLock;

use crate::router::Router;
use crate::shared::data::{self, DATABASE, RouterID};
use tower_http::cors::CorsLayer;

#[derive(Serialize, Clone)]
pub struct Info<'a> {
    pub routers: &'a Vec<data::Router>,
    pub connections: &'a BTreeMap<RouterID, BTreeMap<RouterID, data::Connection>>,
}

pub fn create_app(routers: Arc<RwLock<BTreeMap<RouterID, Router>>>) -> axum::Router {
    axum::Router::new()
        .route(
            "/info",
            get(|| async move {
                Json(Info {
                    routers: &DATABASE.routers,
                    connections: &DATABASE.connections,
                })
            }),
        )
        .route("/metrics", get(|| async move { Json(routers.read().await.clone()) }))
        .layer(CorsLayer::permissive())
}
