import {Component, OnInit} from '@angular/core';
import {ApiService} from "./api.service";
import {firstValueFrom} from "rxjs";
import * as _ from 'lodash';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {
  routers = firstValueFrom(this.api.status())

  constructor(private api: ApiService) {
  }

  async ngOnInit() {
    const protos = []
    const routers = await this.routers;
    for (const from of routers) {
      for (const [id1, peer] of Object.entries(from.peers)) {
        const id = parseInt(id1);
        const reverse = routers.find(r => r.id === id)?.peers?.[from.id];
        if (!reverse) continue;
        const link = this.api.link(from.id, id);
        if (!link) continue;
        if (peer.reliability * reverse.reliability <= 0.01) {
          const proto = link.split(',')[1];
          protos.push(proto);
          if (proto === 'wg') {
            // console.log
          }
        }
      }
    }
    console.log(_.groupBy(protos));
  }
}
