import {Injectable} from '@angular/core';
import {HttpClient} from "@angular/common/http";
import {firstValueFrom, mergeMap, timer} from "rxjs";
import {map} from "rxjs/operators";

@Injectable({
  providedIn: 'root'
})
export class ApiService {

  constructor(private http: HttpClient) {
  }

  status() {
    return timer(0, 1000).pipe(
      mergeMap(() => this.http.get<RouterStatus[]>('http://10.198.0.7:500/')),
      // map((routers) => routers.map(r => ));
    )
  }

  statusFor(id: number) {
    return this.status().pipe(
      map(routers => routers.find(r => r.id == id)!)
    )
  }

  link(from: number, to: number) {
    const [min, max] = [from, to].sort();
    return connected[min][max];
  }
}

export interface RouterStatus {
  id: number,
  name: string,
  address: string,
  location: string,
  peers: Record<number, PeerQuality>,
  via: Record<number, number>
}

export interface PeerQuality {
  delay: number;
  jitter: number;
  reliability: number;
}

const data = [{
  "id": 1,
  "name": "yangtze",
  "address": "10.198.0.1",
  "masqInterfaces": "",
  "location": "CN-SHA",
  "user": "root",
  "host": "yangtze.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": 55322,
  "sshSystem": 55322,
  "nextMark": 1201,
  "destMark": 1501,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "",
  "south": "",
  "ayane": "",
  "satori": "",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28001,
  "offset": 0,
  "port2": 28301,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 3,
  "name": "south",
  "address": "10.198.0.3",
  "masqInterfaces": "",
  "location": "CN-SHA",
  "user": "root",
  "host": "south.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1203,
  "destMark": 1503,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,oc,p=tcp",
  "south": "",
  "ayane": "",
  "satori": "",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28003,
  "offset": 0,
  "port2": 28303,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 4,
  "name": "ayane",
  "address": "10.198.0.4",
  "masqInterfaces": "",
  "location": "CN-SZX",
  "user": "nanahira",
  "host": "ayane-v4.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1204,
  "destMark": 1504,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg,ipv6=off",
  "south": "100,wg",
  "ayane": "",
  "satori": "",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28004,
  "offset": 0,
  "port2": 28304,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 5,
  "name": "satori",
  "address": "10.198.0.5",
  "masqInterfaces": "",
  "location": "CN-YTY",
  "user": "nanahira",
  "host": "satori.moecube.com",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1205,
  "destMark": 1505,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,oc,p=tcp",
  "south": "100,oc,p=tcp",
  "ayane": "100,oc,p=tcp",
  "satori": "",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28005,
  "offset": 0,
  "port2": 28305,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 6,
  "name": "koishi",
  "address": "10.198.0.6",
  "masqInterfaces": "",
  "location": "CN-JIU",
  "user": "nanahira",
  "host": "yumesaki.momobako.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1206,
  "destMark": 1506,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,oc,p=tcp",
  "south": "100,oc,p=tcp",
  "ayane": "100,oc,p=tcp",
  "satori": "100,oc,p=tcp",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28006,
  "offset": 0,
  "port2": 28306,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 7,
  "name": "fractal",
  "address": "10.198.0.7",
  "masqInterfaces": "",
  "location": "CN-SZX",
  "user": "nanahira",
  "host": "yuzurisa-1.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1207,
  "destMark": 1507,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg,lif=ct2,ipv6=off",
  "south": "100,wg,lif=ct2",
  "ayane": "100,wg,ipv6=force",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28007,
  "offset": 0,
  "port2": 28307,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 8,
  "name": "nanahira",
  "address": "10.198.0.22",
  "masqInterfaces": "ens3",
  "location": "US-SJC",
  "user": "nanahira",
  "host": "nanahira.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1208,
  "destMark": 1508,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "240,oc,p=tcp",
  "south": "300,oc,p=tcp",
  "ayane": "300,oc",
  "satori": "300,oc,p=tcp",
  "koishi": "300,oc,p=tcp",
  "fractal": "300,oc",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28008,
  "offset": 0,
  "port2": 28308,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 9,
  "name": "marcia",
  "address": "10.198.0.9",
  "masqInterfaces": "",
  "location": "CN-SZX",
  "user": "nanahira",
  "host": "marcia-v4.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1209,
  "destMark": 1509,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg,ipv6=off",
  "south": "100,wg",
  "ayane": "100,wg,ipv6=force",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "40,tun,if=tr069a",
  "nanahira": "300,oc",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28009,
  "offset": 0,
  "port2": 28309,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 10,
  "name": "anillc",
  "address": "10.198.0.10",
  "masqInterfaces": "",
  "location": "CN-SHA",
  "user": "root",
  "host": "1.1.1.1",
  "ocservCert": "",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1210,
  "destMark": 1510,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "",
  "ayane": "",
  "satori": "",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28010,
  "offset": 0,
  "port2": 28310,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 11,
  "name": "crest",
  "address": "10.198.0.15",
  "masqInterfaces": "eth0",
  "location": "US-LAX",
  "user": "root",
  "host": "crest.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1211,
  "destMark": 1511,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "300,oc,p=tcp",
  "south": "300,oc,p=tcp",
  "ayane": "300,oc",
  "satori": "300,oc,p=tcp",
  "koishi": "300,oc,p=tcp",
  "fractal": "300,oc",
  "nanahira": "100,wg",
  "marcia": "300,oc",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28011,
  "offset": 0,
  "port2": 28311,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 12,
  "name": "hk-hkg-alql2",
  "address": "10.198.0.12",
  "masqInterfaces": "eth0",
  "location": "HK-HKG",
  "user": "root",
  "host": "hk-hkg-alql2.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1212,
  "destMark": 1512,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "180,oc,p=tcp",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc",
  "satori": "200,oc,p=tcp",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,tun",
  "nanahira": "160,wg",
  "marcia": "200,oc",
  "anillc": "",
  "crest": "160,wg",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28012,
  "offset": 0,
  "port2": 28312,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 13,
  "name": "hk-hkg-alql3",
  "address": "10.198.0.20",
  "masqInterfaces": "eth0",
  "location": "HK-HKG",
  "user": "root",
  "host": "hk-hkg-alql3.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1213,
  "destMark": 1513,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "180,oc,p=tcp",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc",
  "satori": "200,oc,p=tcp",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,oc",
  "nanahira": "160,wg",
  "marcia": "200,oc",
  "anillc": "",
  "crest": "160,wg",
  "hk-hkg-alql2": "20,wg,if=vpc",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28013,
  "offset": 0,
  "port2": 28313,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 14,
  "name": "frog",
  "address": "10.198.0.8",
  "masqInterfaces": "",
  "location": "CN-SHA",
  "user": "root",
  "host": "koishi.mycard.moe",
  "ocservCert": "",
  "sshPort": 40008,
  "sshSystem": "",
  "nextMark": 1214,
  "destMark": 1514,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "200,oc,p=tcp",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc,p=tcp",
  "satori": "200,oc,p=tcp",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,oc,p=tcp",
  "nanahira": "200,oc,p=tcp",
  "marcia": "200,oc,p=tcp",
  "anillc": "",
  "crest": "200,oc,p=tcp",
  "hk-hkg-alql2": "200,oc,p=tcp",
  "hk-hkg-alql3": "200,oc,p=tcp",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28014,
  "offset": 0,
  "port2": 28314,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 15,
  "name": "ailizijiang",
  "address": "10.198.0.41",
  "masqInterfaces": "eth0",
  "location": "JP-NRT",
  "user": "root",
  "host": "ailizijiang.wenaiwu.net",
  "ocservCert": "wenyuanji.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1215,
  "destMark": 1515,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "180,oc,p=tcp",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc",
  "satori": "200,oc,p=tcp",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,oc",
  "nanahira": "160,wg",
  "marcia": "200,oc",
  "anillc": "",
  "crest": "160,wg",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28015,
  "offset": 0,
  "port2": 28315,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 16,
  "name": "kano",
  "address": "10.198.0.14",
  "masqInterfaces": "enp0s3",
  "location": "KR-SEL",
  "user": "ubuntu",
  "host": "kano2.mycard.moe",
  "ocservCert": "",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1216,
  "destMark": 1516,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "260,tun",
  "south": "300,tun",
  "ayane": "300,tun",
  "satori": "300,tun",
  "koishi": "300,tun",
  "fractal": "300,tun",
  "nanahira": "300,tun",
  "marcia": "300,tun",
  "anillc": "",
  "crest": "300,tun",
  "hk-hkg-alql2": "300,tun",
  "hk-hkg-alql3": "300,tun",
  "frog": "200,wg",
  "ailizijiang": "200,tun",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28016,
  "offset": 0,
  "port2": 28316,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 17,
  "name": "ge-muc-uma",
  "address": "10.198.0.18",
  "masqInterfaces": "ens3",
  "location": "GE-MUC",
  "user": "root",
  "host": "ge-muc-uma.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1217,
  "destMark": 1517,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "300,oc,p=tcp",
  "south": "300,oc,p=tcp",
  "ayane": "300,oc",
  "satori": "300,oc,p=tcp",
  "koishi": "300,oc,p=tcp",
  "fractal": "300,oc",
  "nanahira": "300,oc",
  "marcia": "300,oc",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "300,oc",
  "hk-hkg-alql3": "300,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28017,
  "offset": 0,
  "port2": 28317,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 18,
  "name": "sakuya",
  "address": "10.198.0.16",
  "masqInterfaces": "eth0",
  "location": "TW-TPE",
  "user": "root",
  "host": "sakuya.touhou.cc",
  "ocservCert": "mycard.moe",
  "sshPort": 40000,
  "sshSystem": "",
  "nextMark": 1218,
  "destMark": 1518,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "230,oc,p=tcp",
  "south": "250,oc,p=tcp",
  "ayane": "250,oc",
  "satori": "250,oc,p=tcp",
  "koishi": "250,oc,p=tcp",
  "fractal": "250,oc",
  "nanahira": "250,oc",
  "marcia": "250,oc",
  "anillc": "",
  "crest": "250,oc",
  "hk-hkg-alql2": "150,oc",
  "hk-hkg-alql3": "150,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "250,oc",
  "kano": "250,wg",
  "ge-muc-uma": "300,oc",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28018,
  "offset": 0,
  "port2": 28318,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 40001
}, {
  "id": 19,
  "name": "monika",
  "address": "10.198.0.21",
  "masqInterfaces": "",
  "location": "US-SEA",
  "user": "root",
  "host": "monika.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1219,
  "destMark": 1519,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "300,oc,p=tcp",
  "south": "300,oc,p=tcp",
  "ayane": "300,oc",
  "satori": "300,oc,p=tcp",
  "koishi": "300,oc,p=tcp",
  "fractal": "300,oc",
  "nanahira": "100,wg",
  "marcia": "300,oc",
  "anillc": "",
  "crest": "100,wg",
  "hk-hkg-alql2": "160,wg",
  "hk-hkg-alql3": "160,wg",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "160,wg",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28019,
  "offset": 0,
  "port2": 28319,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 24,
  "name": "palm",
  "address": "10.198.0.34",
  "masqInterfaces": "",
  "location": "CN-ZB",
  "user": "root",
  "host": "yumesaki.momobako.com",
  "ocservCert": "",
  "sshPort": 40000,
  "sshSystem": "",
  "nextMark": 1224,
  "destMark": 1524,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,wg",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,wg",
  "hk-hkg-alql2": "300,wg",
  "hk-hkg-alql3": "300,wg",
  "frog": "",
  "ailizijiang": "300,wg",
  "kano": "300,wg",
  "ge-muc-uma": "300,wg",
  "sakuya": "250,oc",
  "monika": "300,wg",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28024,
  "offset": 0,
  "port2": 28324,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 25,
  "name": "pekunicom",
  "address": "10.198.0.40",
  "masqInterfaces": "ens3",
  "location": "CN-PEK",
  "user": "root",
  "host": "pekunicom.mycard.moe",
  "ocservCert": "mycard.moe",
  "sshPort": 30000,
  "sshSystem": "",
  "nextMark": 1225,
  "destMark": 1525,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "110,oc",
  "south": "110,oc",
  "ayane": "110,oc",
  "satori": "110,oc,p=tcp",
  "koishi": "110,oc,p=tcp",
  "fractal": "110,oc",
  "nanahira": "300,oc",
  "marcia": "110,oc",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "300,oc",
  "hk-hkg-alql3": "300,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "300,oc",
  "kano": "300,wg",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "110,oc",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28025,
  "offset": 0,
  "port2": 28325,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 30019
}, {
  "id": 26,
  "name": "jue",
  "address": "10.198.0.32",
  "masqInterfaces": "ens3",
  "location": "JP-JPN",
  "user": "root",
  "host": "ailizijiang.wenaiwu.net",
  "ocservCert": "mycard.moe",
  "sshPort": 63222,
  "sshSystem": "",
  "nextMark": 1226,
  "destMark": 1526,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "150,oc,p=tcp",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc,p=tcp",
  "satori": "200,oc,p=tcp",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,oc,p=tcp",
  "nanahira": "200,oc,p=tcp",
  "marcia": "200,oc,p=tcp",
  "anillc": "",
  "crest": "200,oc,p=tcp",
  "hk-hkg-alql2": "200,oc,p=tcp",
  "hk-hkg-alql3": "200,oc,p=tcp",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "100,wg",
  "kano": "200,wg",
  "ge-muc-uma": "300,oc,p=tcp",
  "sakuya": "250,oc,p=tcp",
  "monika": "200,oc,p=tcp",
  "palm": "200,oc,p=tcp",
  "pekunicom": "200,oc,p=tcp",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28026,
  "offset": 0,
  "port2": 28326,
  "offset2": 0,
  "frpsPort": 50102,
  "ocservPort": 50101
}, {
  "id": 28,
  "name": "bluebird",
  "address": "10.198.0.36",
  "masqInterfaces": "eth0",
  "location": "CN-PEK",
  "user": "root",
  "host": "bluebird.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1228,
  "destMark": 1528,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28028,
  "offset": 0,
  "port2": 28328,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 29,
  "name": "chikaanna",
  "address": "10.198.0.35",
  "masqInterfaces": "eth0",
  "location": "CN-SZX",
  "user": "root",
  "host": "chikaanna.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1229,
  "destMark": 1529,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28029,
  "offset": 0,
  "port2": 28329,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 30,
  "name": "cain",
  "address": "10.198.0.17",
  "masqInterfaces": "",
  "location": "CN-SHE",
  "user": "root",
  "host": "10.198.10.1",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1230,
  "destMark": 1530,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "110,oc",
  "south": "110,oc",
  "ayane": "110,oc",
  "satori": "110,oc,p=tcp",
  "koishi": "110,oc,p=tcp",
  "fractal": "110,oc",
  "nanahira": "300,oc",
  "marcia": "110,oc",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "300,oc",
  "hk-hkg-alql3": "300,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "300,oc",
  "kano": "300,wg",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "110,oc",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "110,oc",
  "chikaanna": "110,oc",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28030,
  "offset": 0,
  "port2": 28330,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 219
}, {
  "id": 32,
  "name": "hime",
  "address": "10.198.0.25",
  "masqInterfaces": "eth0",
  "location": "CN-SZX",
  "user": "root",
  "host": "hime.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1232,
  "destMark": 1532,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28032,
  "offset": 0,
  "port2": 28332,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 33,
  "name": "shirayuki",
  "address": "10.198.0.28",
  "masqInterfaces": "eth0",
  "location": "CN-SHA",
  "user": "root",
  "host": "shirayuki.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1233,
  "destMark": 1533,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28033,
  "offset": 0,
  "port2": 28333,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 35,
  "name": "whitelight",
  "address": "10.198.0.42",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "whitelight.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1235,
  "destMark": 1535,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28035,
  "offset": 0,
  "port2": 28335,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 37,
  "name": "nekoyuki",
  "address": "10.198.0.37",
  "masqInterfaces": "eth0",
  "location": "SG-SIN",
  "user": "root",
  "host": "nekoyuki.wenaiwu.net",
  "ocservCert": "wenyuanji.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1237,
  "destMark": 1537,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "180,oc,p=tcp",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc",
  "satori": "200,oc,p=tcp",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,oc",
  "nanahira": "160,wg",
  "marcia": "200,oc",
  "anillc": "",
  "crest": "160,wg",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "160,wg",
  "palm": "200,oc",
  "pekunicom": "200,oc",
  "jue": "200,oc",
  "bluebird": "200,oc",
  "chikaanna": "200,oc",
  "cain": "200,oc",
  "hime": "200,oc",
  "shirayuki": "200,oc",
  "whitelight": "200,oc",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28037,
  "offset": 0,
  "port2": 28337,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 38,
  "name": "rossa",
  "address": "10.198.0.38",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "rossa.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1238,
  "destMark": 1538,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28038,
  "offset": 0,
  "port2": 28338,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 39,
  "name": "tsan",
  "address": "10.198.0.39",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "tsan.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": 62222,
  "sshSystem": 62222,
  "nextMark": 1239,
  "destMark": 1539,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28039,
  "offset": 0,
  "port2": 28339,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 40,
  "name": "budingocg",
  "address": "10.198.0.13",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "budingocg.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1240,
  "destMark": 1540,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "10,wg,if=vpc",
  "tsan": "100,wg",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28040,
  "offset": 0,
  "port2": 28340,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 41,
  "name": "hlsj-vpn-3",
  "address": "10.198.0.53",
  "masqInterfaces": "eth0",
  "location": "CN-SZX",
  "user": "root",
  "host": "hlsj-vpn-3.momobako.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1241,
  "destMark": 1541,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28041,
  "offset": 0,
  "port2": 28341,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 42,
  "name": "kino-enter",
  "address": "10.198.0.23",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "kino-enter.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": 62222,
  "sshSystem": 62222,
  "nextMark": 1242,
  "destMark": 1542,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "",
  "ayane": "100,wg",
  "satori": "",
  "koishi": "",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28042,
  "offset": 0,
  "port2": 28342,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 44,
  "name": "tx-sha-xs",
  "address": "10.198.0.44",
  "masqInterfaces": "eth0",
  "location": "CN-SHA",
  "user": "root",
  "host": "tx-sha-xs.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1244,
  "destMark": 1544,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "100,wg",
  "kino-enter": "100,wg",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28044,
  "offset": 0,
  "port2": 28344,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 45,
  "name": "tx-sha-hd",
  "address": "10.198.0.45",
  "masqInterfaces": "eth0",
  "location": "CN-SHA",
  "user": "root",
  "host": "tx-sha-hd.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1245,
  "destMark": 1545,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "100,wg",
  "kino-enter": "100,wg",
  "tx-sha-xs": "100,wg",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28045,
  "offset": 0,
  "port2": 28345,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 46,
  "name": "tx-pek-wl",
  "address": "10.198.0.46",
  "masqInterfaces": "eth0",
  "location": "CN-PEK",
  "user": "root",
  "host": "tx-pek-wl.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1246,
  "destMark": 1546,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "100,wg",
  "kino-enter": "100,wg",
  "tx-sha-xs": "100,wg",
  "tx-sha-hd": "100,wg",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28046,
  "offset": 0,
  "port2": 28346,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 47,
  "name": "tx-can-hr",
  "address": "10.198.0.47",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "tx-can-hr.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1247,
  "destMark": 1547,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "100,wg",
  "kino-enter": "100,wg",
  "tx-sha-xs": "100,wg",
  "tx-sha-hd": "100,wg",
  "tx-pek-wl": "100,wg",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28047,
  "offset": 0,
  "port2": 28347,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 48,
  "name": "tx-can-qiao",
  "address": "10.198.0.48",
  "masqInterfaces": "eth0",
  "location": "CN-CAN",
  "user": "root",
  "host": "tx-can-qiao.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1248,
  "destMark": 1548,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "100,wg",
  "kino-enter": "100,wg",
  "tx-sha-xs": "100,wg",
  "tx-sha-hd": "100,wg",
  "tx-pek-wl": "100,wg",
  "tx-can-hr": "100,wg",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28048,
  "offset": 0,
  "port2": 28348,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 49,
  "name": "tx-sha-saku",
  "address": "10.198.0.49",
  "masqInterfaces": "eth0",
  "location": "CN-SHA",
  "user": "root",
  "host": "tx-sha-saku.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1249,
  "destMark": 1549,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "100,wg",
  "south": "100,wg",
  "ayane": "100,wg",
  "satori": "100,oc,p=tcp",
  "koishi": "100,oc,p=tcp",
  "fractal": "100,wg,rif=ct2",
  "nanahira": "300,oc",
  "marcia": "100,wg",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "200,oc",
  "hk-hkg-alql3": "200,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "100,wg",
  "pekunicom": "110,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "100,wg",
  "chikaanna": "100,wg",
  "cain": "110,oc",
  "hime": "100,wg",
  "shirayuki": "100,wg",
  "whitelight": "100,wg",
  "nekoyuki": "200,oc",
  "rossa": "100,wg",
  "tsan": "100,wg",
  "budingocg": "100,wg",
  "hlsj-vpn-3": "100,wg",
  "kino-enter": "100,wg",
  "tx-sha-xs": "100,wg",
  "tx-sha-hd": "100,wg",
  "tx-pek-wl": "100,wg",
  "tx-can-hr": "100,wg",
  "tx-can-qiao": "100,wg",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28049,
  "offset": 0,
  "port2": 28349,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 63,
  "name": "kr-chu-cain1",
  "address": "10.198.0.26",
  "masqInterfaces": "ens3",
  "location": "KR-CHU",
  "user": "ubuntu",
  "host": "kr-chu-cain1.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1263,
  "destMark": 1563,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "260,oc,p=tcp",
  "south": "300,oc,p=tcp",
  "ayane": "300,oc",
  "satori": "300,oc",
  "koishi": "300,oc,p=tcp",
  "fractal": "300,oc",
  "nanahira": "300,oc",
  "marcia": "300,oc",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "300,oc",
  "hk-hkg-alql3": "300,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "100,wg",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "300,oc",
  "pekunicom": "300,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "300,oc",
  "chikaanna": "300,oc",
  "cain": "300,oc",
  "hime": "300,oc",
  "shirayuki": "300,oc",
  "whitelight": "300,oc",
  "nekoyuki": "200,oc",
  "rossa": "300,oc",
  "tsan": "300,oc",
  "budingocg": "300,oc",
  "hlsj-vpn-3": "300,oc",
  "kino-enter": "",
  "tx-sha-xs": "300,oc",
  "tx-sha-hd": "300,oc",
  "tx-pek-wl": "300,oc",
  "tx-can-hr": "300,oc",
  "tx-can-qiao": "300,oc",
  "tx-sha-saku": "300,oc",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28063,
  "offset": 0,
  "port2": 28363,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 64,
  "name": "kr-chu-cain2",
  "address": "10.198.0.27",
  "masqInterfaces": "ens3",
  "location": "KR-CHU",
  "user": "ubuntu",
  "host": "kr-chu-cain2.yuzurisa.com",
  "ocservCert": "yuzurisa.com",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1264,
  "destMark": 1564,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "260,oc,p=tcp",
  "south": "300,oc,p=tcp",
  "ayane": "300,oc",
  "satori": "300,oc",
  "koishi": "300,oc,p=tcp",
  "fractal": "300,oc",
  "nanahira": "300,oc",
  "marcia": "300,oc",
  "anillc": "",
  "crest": "300,oc",
  "hk-hkg-alql2": "300,oc",
  "hk-hkg-alql3": "300,oc",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "100,wg",
  "ge-muc-uma": "300,oc",
  "sakuya": "250,oc",
  "monika": "300,oc",
  "palm": "300,oc",
  "pekunicom": "300,oc",
  "jue": "200,oc,p=tcp",
  "bluebird": "300,oc",
  "chikaanna": "300,oc",
  "cain": "300,oc",
  "hime": "300,oc",
  "shirayuki": "300,oc",
  "whitelight": "300,oc",
  "nekoyuki": "200,oc",
  "rossa": "300,oc",
  "tsan": "300,oc",
  "budingocg": "300,oc",
  "hlsj-vpn-3": "300,oc",
  "kino-enter": "",
  "tx-sha-xs": "300,oc",
  "tx-sha-hd": "300,oc",
  "tx-pek-wl": "300,oc",
  "tx-can-hr": "300,oc",
  "tx-can-qiao": "300,oc",
  "tx-sha-saku": "300,oc",
  "kr-chu-cain1": "10,wg,if=vpc",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28064,
  "offset": 0,
  "port2": 28364,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 65,
  "name": "kr-chu-caina",
  "address": "10.198.0.29",
  "masqInterfaces": "enp0s3",
  "location": "KR-CHU",
  "user": "ubuntu",
  "host": "kr-chu-caina.yuzurisa.com",
  "ocservCert": "",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1265,
  "destMark": 1565,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "260,tun",
  "south": "300,tun",
  "ayane": "300,tun",
  "satori": "300,tun",
  "koishi": "300,tun",
  "fractal": "300,tun",
  "nanahira": "300,tun",
  "marcia": "300,tun",
  "anillc": "",
  "crest": "300,tun",
  "hk-hkg-alql2": "300,tun",
  "hk-hkg-alql3": "300,tun",
  "frog": "200,wg",
  "ailizijiang": "200,tun",
  "kano": "100,wg",
  "ge-muc-uma": "300,tun",
  "sakuya": "250,wg",
  "monika": "300,tun",
  "palm": "300,wg",
  "pekunicom": "300,wg",
  "jue": "200,wg",
  "bluebird": "300,tun",
  "chikaanna": "300,tun",
  "cain": "300,wg",
  "hime": "300,tun",
  "shirayuki": "300,tun",
  "whitelight": "300,tun",
  "nekoyuki": "200,tun",
  "rossa": "300,tun",
  "tsan": "300,tun",
  "budingocg": "300,tun",
  "hlsj-vpn-3": "300,tun",
  "kino-enter": "",
  "tx-sha-xs": "300,tun",
  "tx-sha-hd": "300,tun",
  "tx-pek-wl": "300,tun",
  "tx-can-hr": "300,tun",
  "tx-can-qiao": "300,tun",
  "tx-sha-saku": "300,tun",
  "kr-chu-cain1": "10,wg,if=vpc",
  "kr-chu-cain2": "10,wg,if=vpc",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28065,
  "offset": 0,
  "port2": 28365,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 100,
  "name": "mini",
  "address": "10.198.0.100",
  "masqInterfaces": "eth0",
  "location": "CN-SHA",
  "user": "root",
  "host": "poi.lan",
  "ocservCert": "",
  "sshPort": 2022,
  "sshSystem": "",
  "nextMark": 1299,
  "destMark": 1599,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "",
  "south": "100,wg",
  "ayane": "",
  "satori": "",
  "koishi": "",
  "fractal": "",
  "nanahira": "",
  "marcia": "",
  "anillc": "",
  "crest": "",
  "hk-hkg-alql2": "",
  "hk-hkg-alql3": "",
  "frog": "",
  "ailizijiang": "",
  "kano": "",
  "ge-muc-uma": "",
  "sakuya": "",
  "monika": "",
  "palm": "",
  "pekunicom": "",
  "jue": "",
  "bluebird": "",
  "chikaanna": "",
  "cain": "",
  "hime": "",
  "shirayuki": "",
  "whitelight": "",
  "nekoyuki": "",
  "rossa": "",
  "tsan": "",
  "budingocg": "",
  "hlsj-vpn-3": "",
  "kino-enter": "",
  "tx-sha-xs": "",
  "tx-sha-hd": "",
  "tx-pek-wl": "",
  "tx-can-hr": "",
  "tx-can-qiao": "",
  "tx-sha-saku": "",
  "kr-chu-cain1": "",
  "kr-chu-cain2": "",
  "kr-chu-caina": "",
  "mini": "",
  "genz": "",
  "port": 28899,
  "offset": 0,
  "port2": 28799,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}, {
  "id": 101,
  "name": "genz",
  "address": "10.198.0.101",
  "masqInterfaces": "eth0",
  "location": "HK-HKG",
  "user": "root",
  "host": "genz.lv5.ac",
  "ocservCert": "lv5.ac",
  "sshPort": "",
  "sshSystem": "",
  "nextMark": 1243,
  "destMark": 1543,
  "noBird": "",
  "sysBird": "",
  "noDockerOp": "",
  "yangtze": "210,wg",
  "south": "200,oc,p=tcp",
  "ayane": "200,oc",
  "satori": "200,oc",
  "koishi": "200,oc,p=tcp",
  "fractal": "200,oc",
  "nanahira": "160,wg",
  "marcia": "200,oc",
  "anillc": "",
  "crest": "160,wg",
  "hk-hkg-alql2": "100,wg",
  "hk-hkg-alql3": "100,wg",
  "frog": "200,oc,p=tcp",
  "ailizijiang": "200,oc",
  "kano": "300,tun",
  "ge-muc-uma": "300,oc",
  "sakuya": "200,oc",
  "monika": "160,wg",
  "palm": "200,oc",
  "pekunicom": "200,oc",
  "jue": "200,oc",
  "bluebird": "200,oc",
  "chikaanna": "200,oc",
  "cain": "200,oc",
  "hime": "200,oc",
  "shirayuki": "200,oc",
  "whitelight": "",
  "nekoyuki": "200,oc",
  "rossa": "200,oc",
  "tsan": "200,oc",
  "budingocg": "200,oc",
  "hlsj-vpn-3": "200,oc",
  "kino-enter": "",
  "tx-sha-xs": "200,oc",
  "tx-sha-hd": "200,oc",
  "tx-pek-wl": "200,oc",
  "tx-can-hr": "200,oc",
  "tx-can-qiao": "200,oc",
  "tx-sha-saku": "200,oc",
  "kr-chu-cain1": "200,oc",
  "kr-chu-cain2": "200,oc",
  "kr-chu-caina": "300,tun",
  "mini": "",
  "genz": "",
  "port": 28043,
  "offset": 0,
  "port2": 28343,
  "offset2": 0,
  "frpsPort": 28999,
  "ocservPort": 28998
}]

const connected: Record<number, Record<number, string>> = {};
for (const from of data) {
  if (!connected[from.id]) connected[from.id] = {}
  for (const to of data) {
    // @ts-ignore
    if (from[to.name] !== "") {
      const [min, max] = [from.id, to.id].sort();
      // @ts-ignore
      connected[min][max] = from[to.name];
    }
  }
}

console.log(
  data
    .map(item => Object.entries({
      Host: item.name,
      HostName: item.host,
      User: item.user,
      Port: item.sshPort
    })
      .filter(([key, value]) => value)
      .map(((line) => line.join(' ')))
      .join("\n"))
    .join("\n\n")
)
