import express from 'express';
import { Router } from './Router';

export const api = express.Router();

api.get('/', function(req, res, next) {
  const result = Router.all.map(from => ({
    id: from.id,
    peers: from.peers,
    via: Object.fromEntries([...from.via.entries()].map(([to, via]) => [to.id, via.id]))
  }));

  res.json(result);
});
